/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ImplementationEngineTogglePanel;
import org.apache.syncope.client.console.panels.ImplementationModalPanel;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLinksTogglePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;

public class ImplementationDirectoryPanel
extends DirectoryPanel<ImplementationTO, ImplementationTO, ImplementationProvider, ImplementationRestClient> {
    private static final long serialVersionUID = 1868839768348072635L;
    private final String type;

    public ImplementationDirectoryPanel(String id, String type, ImplementationRestClient restClient, PageReference pageRef) {
        super(id, restClient, pageRef, true);
        this.type = type;
        final ImplementationTO implementation = new ImplementationTO();
        implementation.setType(type);
        this.disableCheckBoxes();
        this.modal.size(Modal.Size.Large);
        this.modal.addSubmitButton();
        this.modal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            if (this.actionTogglePanel.isVisibleInHierarchy()) {
                this.actionTogglePanel.toggle(target, false);
            }
            implementation.setEngine(null);
            this.updateResultTable(target);
            this.modal.show(false);
        });
        this.setFooterVisibility(true);
        this.initResultTable();
        final ImplementationEngineTogglePanel engineTogglePanel = new ImplementationEngineTogglePanel(this, "engineTogglePanel", implementation, pageRef){
            private static final long serialVersionUID = -112426445257072782L;
            final /* synthetic */ ImplementationDirectoryPanel this$0;
            {
                this.this$0 = this$0;
                super(id, implementation2, pageRef);
            }

            @Override
            protected void onSubmit(ImplementationEngine engine, AjaxRequestTarget target) {
                implementation.setKey(null);
                implementation.setBody(null);
                target.add(new Component[]{this.this$0.modal.setContent((ModalPanel)new ImplementationModalPanel(this.this$0.modal, implementation, this.pageRef))});
                this.this$0.modal.header((IModel)new StringResourceModel("any.new", (IModel)Model.of((Serializable)implementation)));
                this.this$0.modal.show(true);
            }
        };
        this.addInnerObject(new Component[]{engineTogglePanel});
        AjaxLink<Void> replaceAddLink = new AjaxLink<Void>(this, "add"){
            private static final long serialVersionUID = -7978723352517770644L;
            final /* synthetic */ ImplementationDirectoryPanel this$0;
            {
                this.this$0 = this$0;
                super(id);
            }

            public void onClick(AjaxRequestTarget target) {
                this.send((IEventSink)this.this$0, Broadcast.BREADTH, new ActionLinksTogglePanel.ActionLinkToggleCloseEventPayload(target));
                engineTogglePanel.setHeaderLabel(target);
                engineTogglePanel.toggle(target, true);
            }
        };
        ((WebMarkupContainer)this.get("container:content")).addOrReplace(new Component[]{replaceAddLink});
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"IMPLEMENTATION_CREATE");
    }

    @Override
    protected List<IColumn<ImplementationTO, String>> getColumns() {
        ArrayList<IColumn<ImplementationTO, String>> columns = new ArrayList<IColumn<ImplementationTO, String>>();
        columns.add((IColumn<ImplementationTO, String>)new PropertyColumn((IModel)new StringResourceModel("key", (Component)this), (Object)"key", "key"));
        columns.add((IColumn<ImplementationTO, String>)new PropertyColumn((IModel)new StringResourceModel("engine", (Component)this), (Object)"engine", "engine"));
        return columns;
    }

    @Override
    protected ActionsPanel<ImplementationTO> getActions(final IModel<ImplementationTO> model) {
        ActionsPanel<ImplementationTO> panel = super.getActions(model);
        panel.add(new ActionLink<ImplementationTO>(this){
            private static final long serialVersionUID = -7978723352517770645L;
            final /* synthetic */ ImplementationDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onClick(AjaxRequestTarget target, ImplementationTO ignore) {
                target.add(new Component[]{this.this$0.modal.setContent((ModalPanel)new ImplementationModalPanel(this.this$0.modal, (ImplementationTO)model.getObject(), this.this$0.pageRef))});
                this.this$0.modal.header((IModel)new StringResourceModel("any.edit", (IModel)Model.of((Serializable)((ImplementationTO)model.getObject()))));
                this.this$0.modal.show(true);
            }
        }, ActionLink.ActionType.EDIT, "IMPLEMENTATION_UPDATE");
        panel.add(new ActionLink<ImplementationTO>(this){
            private static final long serialVersionUID = -3722207913631435501L;
            final /* synthetic */ ImplementationDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onClick(AjaxRequestTarget target, ImplementationTO ignore) {
                try {
                    ((ImplementationRestClient)this.this$0.restClient).delete(((ImplementationTO)model.getObject()).getType(), ((ImplementationTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.this$0.getString("operation_succeeded")));
                    target.add(new Component[]{this.this$0.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting object {}", (Object)((ImplementationTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)this.this$0.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "IMPLEMENTATION_DELETE", true);
        return panel;
    }

    @Override
    protected ImplementationProvider dataProvider() {
        return new ImplementationProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "implementation.paginator.rows";
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    protected class ImplementationProvider
    extends DirectoryDataProvider<ImplementationTO> {
        private static final long serialVersionUID = 8594921866993979224L;
        private final SortableDataProviderComparator<ImplementationTO> comparator;

        public ImplementationProvider(int paginatorRows) {
            super(paginatorRows);
            this.comparator = new SortableDataProviderComparator<ImplementationTO>(this);
        }

        public Iterator<ImplementationTO> iterator(long first, long count) {
            List<ImplementationTO> implementations = ((ImplementationRestClient)ImplementationDirectoryPanel.this.restClient).list(ImplementationDirectoryPanel.this.type);
            implementations.sort(this.comparator);
            return implementations.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((ImplementationRestClient)ImplementationDirectoryPanel.this.restClient).list(ImplementationDirectoryPanel.this.type).size();
        }

        public IModel<ImplementationTO> model(final ImplementationTO implementation) {
            return new IModel<ImplementationTO>(this){
                private static final long serialVersionUID = 999513782683391483L;
                final /* synthetic */ ImplementationProvider this$1;
                {
                    this.this$1 = this$1;
                }

                public ImplementationTO getObject() {
                    return implementation;
                }
            };
        }
    }
}

