/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.BooleanReplacePatchItem;
import org.apache.syncope.common.lib.request.MembershipUR;
import org.apache.syncope.common.lib.request.PasswordPatch;
import org.apache.syncope.common.lib.request.StatusR;
import org.apache.syncope.common.lib.request.StringPatchItem;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.StatusRType;
import org.apache.syncope.common.rest.api.beans.ComplianceQuery;
import org.apache.syncope.core.logic.AbstractAnyLogic;
import org.apache.syncope.core.logic.SyncopeLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.EncryptorManager;
import org.apache.syncope.core.persistence.api.attrvalue.InvalidEntityException;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.DelegationDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.search.SyncopePage;
import org.apache.syncope.core.persistence.api.utils.RealmUtils;
import org.apache.syncope.core.provisioning.api.ProvisioningManager;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.jexl.TemplateUtils;
import org.apache.syncope.core.provisioning.api.rules.RuleProvider;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.policy.AccountPolicyException;
import org.apache.syncope.core.spring.policy.PasswordPolicyException;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class UserLogic
extends AbstractAnyLogic<UserTO, UserCR, UserUR> {
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final AnySearchDAO searchDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final AccessTokenDAO accessTokenDAO;
    protected final DelegationDAO delegationDAO;
    protected final ConfParamOps confParamOps;
    protected final UserDataBinder binder;
    protected final UserProvisioningManager provisioningManager;
    protected final SyncopeLogic syncopeLogic;
    protected final RuleProvider ruleEnforcer;
    protected final EncryptorManager encryptorManager;

    public UserLogic(RealmSearchDAO realmSearchDAO, AnyTypeDAO anyTypeDAO, TemplateUtils templateUtils, UserDAO userDAO, GroupDAO groupDAO, AnySearchDAO searchDAO, ExternalResourceDAO resourceDAO, AccessTokenDAO accessTokenDAO, DelegationDAO delegationDAO, ConfParamOps confParamOps, UserDataBinder binder, UserProvisioningManager provisioningManager, SyncopeLogic syncopeLogic, RuleProvider ruleEnforcer, EncryptorManager encryptorManager) {
        super(realmSearchDAO, anyTypeDAO, templateUtils);
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.searchDAO = searchDAO;
        this.resourceDAO = resourceDAO;
        this.accessTokenDAO = accessTokenDAO;
        this.delegationDAO = delegationDAO;
        this.confParamOps = confParamOps;
        this.binder = binder;
        this.provisioningManager = provisioningManager;
        this.syncopeLogic = syncopeLogic;
        this.ruleEnforcer = ruleEnforcer;
        this.encryptorManager = encryptorManager;
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('MUST_CHANGE_PASSWORD'))")
    @Transactional(readOnly=true)
    public Self selfRead() {
        UserTO authenticatedUser = this.binder.getAuthenticatedUserTO();
        return new Self(authenticatedUser, POJOHelper.serialize((Object)AuthContextUtils.getAuthorizations()), POJOHelper.serialize((Object)this.delegationDAO.findValidDelegating(authenticatedUser.getKey(), OffsetDateTime.now())));
    }

    @Override
    @PreAuthorize(value="hasRole('USER_READ')")
    @Transactional(readOnly=true)
    public UserTO read(String key) {
        return this.binder.getUserTO(key);
    }

    @Override
    @PreAuthorize(value="hasRole('USER_SEARCH')")
    @Transactional(readOnly=true)
    public Page<UserTO> search(SearchCond searchCond, Pageable pageable, String realm, boolean recursive, boolean details) {
        Realm base = (Realm)this.realmSearchDAO.findByFullPath(realm).orElseThrow(() -> new NotFoundException("Realm " + realm));
        Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_SEARCH")), (String)realm);
        SearchCond effectiveCond = searchCond == null ? this.userDAO.getAllMatchingCond() : searchCond;
        long count = this.searchDAO.count(base, recursive, authRealms, effectiveCond, AnyTypeKind.USER);
        List matching = this.searchDAO.search(base, recursive, authRealms, effectiveCond, pageable, AnyTypeKind.USER);
        List<UserTO> result = matching.stream().map(user -> this.binder.getUserTO(user, details)).toList();
        return new SyncopePage(result, pageable, count);
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public ProvisioningResult<UserTO> selfCreate(UserCR createReq, boolean nullPriorityAsync) {
        return this.doCreate(createReq, true, nullPriorityAsync);
    }

    @PreAuthorize(value="hasRole('USER_CREATE')")
    public ProvisioningResult<UserTO> create(UserCR createReq, boolean nullPriorityAsync) {
        return this.doCreate(createReq, false, nullPriorityAsync);
    }

    protected ProvisioningResult<UserTO> doCreate(UserCR userCR, boolean self, boolean nullPriorityAsync) {
        AbstractAnyLogic.BeforeResult<UserCR> before = this.beforeCreate(userCR);
        if (before.key().getRealm() == null) {
            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
        }
        if (!self) {
            Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_CREATE")), (String)before.key().getRealm());
            this.userDAO.securityChecks(authRealms, null, before.key().getRealm(), (Collection)before.key().getMemberships().stream().filter(Objects::nonNull).map(MembershipTO::getGroupKey).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        ProvisioningManager.ProvisioningResult created = this.provisioningManager.create((AnyCR)before.key(), nullPriorityAsync, AuthContextUtils.getUsername(), "REST");
        return this.afterCreate(this.binder.getUserTO((String)created.key()), created.statuses(), before.actions());
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('ANONYMOUS')) and not(hasRole('MUST_CHANGE_PASSWORD'))")
    public ProvisioningResult<UserTO> selfUpdate(UserUR userUR, boolean nullPriorityAsync) {
        UserTO userTO = this.binder.getAuthenticatedUserTO();
        userUR.setKey(userTO.getKey());
        ProvisioningResult<UserTO> updated = this.doUpdate(userUR, true, nullPriorityAsync);
        List<String> authStatuses = List.of((String[])this.confParamOps.get(AuthContextUtils.getDomain(), "authentication.statuses", (Object)new String[0], String[].class));
        if (!authStatuses.contains(((UserTO)updated.getEntity()).getStatus())) {
            this.accessTokenDAO.findByOwner(((UserTO)updated.getEntity()).getUsername()).ifPresent(arg_0 -> ((AccessTokenDAO)this.accessTokenDAO).delete(arg_0));
        }
        return updated;
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public ProvisioningResult<UserTO> update(UserUR userUR, boolean nullPriorityAsync) {
        return this.doUpdate(userUR, false, nullPriorityAsync);
    }

    protected Set<String> groups(UserTO userTO) {
        return userTO.getMemberships().stream().filter(Objects::nonNull).map(MembershipTO::getGroupKey).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    protected ProvisioningResult<UserTO> doUpdate(UserUR userUR, boolean self, boolean nullPriorityAsync) {
        UserTO userTO = this.binder.getUserTO(userUR.getKey());
        AbstractAnyLogic.BeforeResult<UserUR> before = this.beforeUpdate(userUR, userTO.getRealm());
        Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_UPDATE")), (String)userTO.getRealm());
        if (!self) {
            Set<String> groups = this.groups(userTO);
            groups.removeAll(userUR.getMemberships().stream().filter(Objects::nonNull).filter(m -> m.getOperation() == PatchOperation.DELETE).map(MembershipUR::getGroup).filter(Objects::nonNull).collect(Collectors.toSet()));
            this.userDAO.securityChecks(authRealms, before.key().getKey(), userTO.getRealm(), groups);
        }
        ProvisioningManager.ProvisioningResult after = this.provisioningManager.update(before.key(), nullPriorityAsync, AuthContextUtils.getUsername(), "REST");
        ProvisioningResult<UserTO> result = this.afterUpdate(this.binder.getUserTO(((UserUR)after.key()).getKey()), after.statuses(), before.actions());
        return result;
    }

    protected ProvisioningManager.ProvisioningResult<String> setStatusOnWfAdapter(StatusR statusR, boolean nullPriorityAsync) {
        return switch (statusR.getType()) {
            case StatusRType.SUSPEND -> this.provisioningManager.suspend(statusR, nullPriorityAsync, AuthContextUtils.getUsername(), "REST");
            case StatusRType.REACTIVATE -> this.provisioningManager.reactivate(statusR, nullPriorityAsync, AuthContextUtils.getUsername(), "REST");
            default -> this.provisioningManager.activate(statusR, nullPriorityAsync, AuthContextUtils.getUsername(), "REST");
        };
    }

    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public ProvisioningResult<UserTO> status(StatusR statusR, boolean nullPriorityAsync) {
        UserTO toUpdate = this.binder.getUserTO(statusR.getKey());
        Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_UPDATE")), (String)toUpdate.getRealm());
        this.userDAO.securityChecks(authRealms, toUpdate.getKey(), toUpdate.getRealm(), this.groups(toUpdate));
        statusR.setKey(toUpdate.getKey());
        ProvisioningManager.ProvisioningResult<String> updated = this.setStatusOnWfAdapter(statusR, nullPriorityAsync);
        return this.afterUpdate(this.binder.getUserTO((String)updated.key()), updated.statuses(), List.of());
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('MUST_CHANGE_PASSWORD'))")
    public ProvisioningResult<UserTO> selfStatus(StatusR statusR, boolean nullPriorityAsync) {
        statusR.setKey((String)this.userDAO.findKey(AuthContextUtils.getUsername()).orElseThrow(() -> new NotFoundException("Could not find authenticated user")));
        ProvisioningManager.ProvisioningResult<String> updated = this.setStatusOnWfAdapter(statusR, nullPriorityAsync);
        return this.afterUpdate(this.binder.getUserTO((String)updated.key()), updated.statuses(), List.of());
    }

    @PreAuthorize(value="hasRole('MUST_CHANGE_PASSWORD')")
    public ProvisioningResult<UserTO> mustChangePassword(PasswordPatch password, boolean nullPriorityAsync) {
        UserTO userTO = this.binder.getAuthenticatedUserTO();
        password.setOnSyncope(true);
        password.getResources().clear();
        password.getResources().addAll(this.userDAO.findAllResourceKeys(userTO.getKey()));
        UserUR userUR = (UserUR)new UserUR.Builder(userTO.getKey()).password(password).mustChangePassword((BooleanReplacePatchItem)((BooleanReplacePatchItem.Builder)new BooleanReplacePatchItem.Builder().value((Object)false)).build()).build();
        ProvisioningResult<UserTO> result = this.selfUpdate(userUR, nullPriorityAsync);
        this.accessTokenDAO.findByOwner(((UserTO)result.getEntity()).getUsername()).ifPresent(arg_0 -> ((AccessTokenDAO)this.accessTokenDAO).delete(arg_0));
        return result;
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public void compliance(ComplianceQuery query) {
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RESTValidation);
        if (query.isEmpty()) {
            sce.getElements().add("Nothing to check");
            throw sce;
        }
        Realm realm = null;
        if (StringUtils.isNotBlank((CharSequence)query.getRealm())) {
            realm = (Realm)this.realmSearchDAO.findByFullPath(query.getRealm()).orElseThrow(() -> new NotFoundException("Realm " + query.getRealm()));
        }
        Set resources = query.getResources().stream().map(arg_0 -> ((ExternalResourceDAO)this.resourceDAO).findById(arg_0)).flatMap(Optional::stream).collect(Collectors.toSet());
        if (realm == null && resources.isEmpty()) {
            sce.getElements().add("Nothing to check");
            throw sce;
        }
        if (StringUtils.isNotBlank((CharSequence)query.getUsername())) {
            List accountPolicies = this.ruleEnforcer.getAccountPolicies(realm, resources);
            try {
                if (accountPolicies.isEmpty()) {
                    if (!Entity.ID_PATTERN.matcher(query.getUsername()).matches()) {
                        throw new AccountPolicyException("Character(s) not allowed: " + query.getUsername());
                    }
                } else {
                    Iterator iterator = accountPolicies.iterator();
                    while (iterator.hasNext()) {
                        AccountPolicy policy = (AccountPolicy)iterator.next();
                        this.ruleEnforcer.getAccountRules(policy).forEach(rule -> rule.enforce(query.getUsername()));
                    }
                }
            }
            catch (AccountPolicyException e) {
                throw new InvalidEntityException(User.class, EntityViolationType.InvalidUsername, e.getMessage());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)query.getPassword())) {
            try {
                for (PasswordPolicy policy : this.ruleEnforcer.getPasswordPolicies(realm, resources)) {
                    this.ruleEnforcer.getPasswordRules(policy).forEach(rule -> rule.enforce(query.getUsername(), query.getPassword()));
                }
            }
            catch (PasswordPolicyException e) {
                throw new InvalidEntityException(User.class, EntityViolationType.InvalidPassword, e.getMessage());
            }
        }
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    @Transactional
    public void requestPasswordReset(String username, String securityAnswer) {
        User user = (User)this.userDAO.findByUsername(username).orElseThrow(() -> new NotFoundException("User " + username));
        if (this.syncopeLogic.isPwdResetRequiringSecurityQuestions() && (securityAnswer == null || !this.encryptorManager.getInstance().verify(securityAnswer, user.getCipherAlgorithm(), user.getSecurityAnswer()))) {
            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSecurityAnswer);
        }
        this.provisioningManager.requestPasswordReset(user.getKey(), AuthContextUtils.getUsername(), "REST");
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    @Transactional
    public void confirmPasswordReset(String token, String password) {
        User user = (User)this.userDAO.findByToken(token).orElseThrow(() -> new NotFoundException("User with token " + token));
        this.provisioningManager.confirmPasswordReset(user.getKey(), token, password, AuthContextUtils.getUsername(), "REST");
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('ANONYMOUS')) and not(hasRole('MUST_CHANGE_PASSWORD'))")
    public ProvisioningResult<UserTO> selfDelete(boolean nullPriorityAsync) {
        return this.doDelete(this.binder.getAuthenticatedUserTO(), true, nullPriorityAsync);
    }

    @Override
    @PreAuthorize(value="hasRole('USER_DELETE')")
    public ProvisioningResult<UserTO> delete(String key, boolean nullPriorityAsync) {
        return this.doDelete(this.binder.getUserTO(key), false, nullPriorityAsync);
    }

    protected ProvisioningResult<UserTO> doDelete(UserTO userTO, boolean self, boolean nullPriorityAsync) {
        UserTO deletedTO;
        AbstractAnyLogic.BeforeResult<UserTO> before = this.beforeDelete(userTO);
        if (!self) {
            Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_DELETE")), (String)before.key().getRealm());
            this.userDAO.securityChecks(authRealms, before.key().getKey(), before.key().getRealm(), this.groups(before.key()));
        }
        if (this.userDAO.isManager(before.key().getKey())) {
            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Management);
        }
        List statuses = this.provisioningManager.delete(before.key().getKey(), nullPriorityAsync, AuthContextUtils.getUsername(), "REST");
        if (this.userDAO.existsById(before.key().getKey())) {
            deletedTO = this.binder.getUserTO(before.key().getKey());
        } else {
            deletedTO = new UserTO();
            deletedTO.setKey(before.key().getKey());
        }
        return this.afterDelete(deletedTO, statuses, before.actions());
    }

    protected void updateChecks(String key) {
        UserTO userTO = this.binder.getUserTO(key);
        Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_UPDATE")), (String)userTO.getRealm());
        this.userDAO.securityChecks(authRealms, userTO.getKey(), userTO.getRealm(), (Collection)userTO.getMemberships().stream().map(MembershipTO::getGroupKey).collect(Collectors.toSet()));
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public UserTO unlink(String key, Collection<String> resources) {
        this.updateChecks(key);
        UserUR req = (UserUR)((UserUR.Builder)new UserUR.Builder(key).resources(resources.stream().map(r -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(r)).build()).toList())).build();
        return this.binder.getUserTO(this.provisioningManager.unlink((AnyUR)req, AuthContextUtils.getUsername(), "REST"));
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public UserTO link(String key, Collection<String> resources) {
        this.updateChecks(key);
        UserUR req = (UserUR)((UserUR.Builder)new UserUR.Builder(key).resources(resources.stream().map(r -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(r)).build()).toList())).build();
        return this.binder.getUserTO(this.provisioningManager.link((AnyUR)req, AuthContextUtils.getUsername(), "REST"));
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public ProvisioningResult<UserTO> unassign(String key, Collection<String> resources, boolean nullPriorityAsync) {
        this.updateChecks(key);
        UserUR req = (UserUR)((UserUR.Builder)new UserUR.Builder(key).resources(resources.stream().map(r -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(r)).build()).toList())).build();
        return this.update(req, nullPriorityAsync);
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public ProvisioningResult<UserTO> assign(String key, Collection<String> resources, boolean changepwd, String password, boolean nullPriorityAsync) {
        this.updateChecks(key);
        UserUR req = (UserUR)((UserUR.Builder)new UserUR.Builder(key).resources(resources.stream().map(r -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(r)).build()).toList())).build();
        if (changepwd) {
            req.setPassword((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().value((Object)password)).onSyncope(false).resources(resources).build());
        }
        return this.update(req, nullPriorityAsync);
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public ProvisioningResult<UserTO> deprovision(String key, List<String> resources, boolean nullPriorityAsync) {
        this.updateChecks(key);
        List statuses = this.provisioningManager.deprovision(key, resources, nullPriorityAsync, AuthContextUtils.getUsername());
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.getUserTO(key));
        result.getPropagationStatuses().addAll(statuses);
        result.getPropagationStatuses().sort(Comparator.comparing(item -> resources.indexOf(item.getResource())));
        return result;
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public ProvisioningResult<UserTO> provision(String key, List<String> resources, boolean changePwd, String password, boolean nullPriorityAsync) {
        this.updateChecks(key);
        List statuses = this.provisioningManager.provision(key, changePwd, password, resources, nullPriorityAsync, AuthContextUtils.getUsername());
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.getUserTO(key));
        result.getPropagationStatuses().addAll(statuses);
        result.getPropagationStatuses().sort(Comparator.comparing(item -> resources.indexOf(item.getResource())));
        return result;
    }

    @PreAuthorize(value="hasRole('USER_SEARCH')")
    @Transactional(readOnly=true)
    public void verifySecurityAnswer(String username, String securityAnswer) {
        User user = (User)this.userDAO.findByUsername(username).orElseThrow(() -> new NotFoundException("User " + username));
        if (this.syncopeLogic.isPwdResetRequiringSecurityQuestions() && (securityAnswer == null || !this.encryptorManager.getInstance().verify(securityAnswer, user.getCipherAlgorithm(), user.getSecurityAnswer()))) {
            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSecurityAnswer);
        }
    }

    @Override
    protected UserTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if ("requestPasswordReset".equals(method.getName())) {
            key = this.userDAO.findKey((String)args[0]).orElse(null);
        } else if (!"confirmPasswordReset".equals(method.getName()) && ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (object instanceof UserTO) {
                    UserTO userTO = (UserTO)object;
                    key = userTO.getKey();
                    continue;
                }
                object = args[i];
                if (object instanceof UserUR) {
                    UserUR userUR = (UserUR)object;
                    key = userUR.getKey();
                    continue;
                }
                object = args[i];
                if (!(object instanceof StatusR)) continue;
                StatusR statusR = (StatusR)object;
                key = statusR.getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getUserTO(key);
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }

    public record Self(UserTO user, String entitlements, String delegations) {
    }
}

