/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.app.verifier;

import com.giffing.wicket.spring.boot.starter.app.verifier.WicketDependencyMismatchDetectedException;
import com.giffing.wicket.spring.boot.starter.app.verifier.WicketDependencyVersionChecker;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;

public class WicketDependencyVersionCheckerFailureAnalyzer
extends AbstractFailureAnalyzer<WicketDependencyMismatchDetectedException> {
    protected FailureAnalysis analyze(Throwable rootFailure, WicketDependencyMismatchDetectedException cause) {
        StringBuilder descriptionMessage = new StringBuilder("One or more Wicket dependencies (jars) doesn't match the wicket-core dependency.\n\r" + "Wicket Core Version: %s%s".formatted(cause.getWicketCoreVersion(), System.lineSeparator()));
        for (WicketDependencyVersionChecker.MavenDependency dependency : cause.getDependencies()) {
            descriptionMessage.append("\t").append(dependency).append(System.lineSeparator());
        }
        String actionMessage = "Please check the Wicket versions configured in your dependency management system (Maven, Gradle, ...)\nYou can disable this check via the property:\n\twicket.verifier.dependencies.enabled=false.\nYou can prevent throwing the exception but still log the detected problems via the property:\n\twicket.verifier.dependencies.throw-exception-on-dependency-version-mismatch=false";
        return new FailureAnalysis(descriptionMessage.toString(), actionMessage, (Throwable)cause);
    }
}

