/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.serialization;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.InjectableValues;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apereo.cas.configuration.support.TriStateBoolean;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;

public class JacksonInjectableValueSupplier
extends InjectableValues.Std {
    private static final long serialVersionUID = -7327438202032303292L;

    public JacksonInjectableValueSupplier(Supplier<? extends Map<String, Object>> valueSupplier) {
        super(valueSupplier.get());
    }

    public Object findInjectableValue(DeserializationContext ctxt, Object valueId, BeanProperty forProperty, Object beanInstance, Boolean optional, Boolean useInput) {
        String key = valueId.toString();
        Object valueToReturn = this._values.get(key);
        DirectFieldAccessFallbackBeanWrapper wrapper = new DirectFieldAccessFallbackBeanWrapper(beanInstance);
        if (!this._values.containsKey(key)) {
            return wrapper.getPropertyValue(key);
        }
        Class propType = Objects.requireNonNull(wrapper.getPropertyType(key));
        if (propType.equals(TriStateBoolean.class)) {
            return TriStateBoolean.valueOf((String)valueToReturn.toString().toUpperCase(Locale.ENGLISH));
        }
        return valueToReturn;
    }
}

