/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.cipher;

import jakarta.servlet.http.HttpServletRequest;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.ConfigurationPropertiesBindingContext;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.crypto.CipherExecutorResolver;

public class DefaultCipherExecutorResolver
implements CipherExecutorResolver {
    private final CipherExecutor cipherExecutor;
    private final TenantExtractor tenantExtractor;
    private final Class cryptoPropertiesClass;
    private final Function<ConfigurationPropertiesBindingContext<CasConfigurationProperties>, CipherExecutor> cipherExecutorSupplier;

    public CipherExecutor resolve(HttpServletRequest request) {
        return this.tenantExtractor.extract(request).map(this::bindTenantToCipherExecutor).orElse(this.cipherExecutor);
    }

    public CipherExecutor resolve(String tenant) {
        if (StringUtils.isBlank((CharSequence)tenant)) {
            return this.cipherExecutor;
        }
        TenantDefinition tenantDefinition = (TenantDefinition)this.tenantExtractor.getTenantsManager().findTenant(tenant).orElseThrow();
        return this.bindTenantToCipherExecutor(tenantDefinition);
    }

    private CipherExecutor bindTenantToCipherExecutor(TenantDefinition tenantDefinition) {
        ConfigurationPropertiesBindingContext bindingContext = tenantDefinition.bindProperties();
        if (bindingContext.isBound() && bindingContext.containsBindingFor(this.cryptoPropertiesClass)) {
            return this.cipherExecutorSupplier.apply((ConfigurationPropertiesBindingContext<CasConfigurationProperties>)bindingContext);
        }
        return this.cipherExecutor;
    }

    @Generated
    public DefaultCipherExecutorResolver(CipherExecutor cipherExecutor, TenantExtractor tenantExtractor, Class cryptoPropertiesClass, Function<ConfigurationPropertiesBindingContext<CasConfigurationProperties>, CipherExecutor> cipherExecutorSupplier) {
        this.cipherExecutor = cipherExecutor;
        this.tenantExtractor = tenantExtractor;
        this.cryptoPropertiesClass = cryptoPropertiesClass;
        this.cipherExecutorSupplier = cipherExecutorSupplier;
    }
}

