/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.validator.routines.EmailValidator;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.handler.PrincipalNameTransformer;
import org.apereo.cas.authentication.principal.PrincipalNameTransformerUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.pm.LdapPasswordManagementProperties;
import org.apereo.cas.pm.PasswordChangeRequest;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.impl.BasePasswordManagementService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LdapConnectionFactory;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.jooq.lambda.Unchecked;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.FilterTemplate;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class LdapPasswordManagementService
extends BasePasswordManagementService
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapPasswordManagementService.class);
    private final Map<String, ConnectionFactory> connectionFactoryMap;

    public LdapPasswordManagementService(CipherExecutor<Serializable, String> cipherExecutor, CasConfigurationProperties casProperties, PasswordHistoryService passwordHistoryService, Map<String, ConnectionFactory> connectionFactoryMap) {
        super(casProperties, cipherExecutor, passwordHistoryService);
        this.connectionFactoryMap = Map.copyOf(connectionFactoryMap);
    }

    public void destroy() {
        this.connectionFactoryMap.forEach((ldap, connectionFactory) -> connectionFactory.close());
    }

    public String findEmail(PasswordManagementQuery query) {
        String email = this.findAttribute(query, this.casProperties.getAuthn().getPm().getReset().getMail().getAttributeName(), CollectionUtils.wrap((Object)query.getUsername()));
        if (EmailValidator.getInstance().isValid(email)) {
            LOGGER.debug("Email address [{}] for [{}] appears valid", (Object)email, (Object)query.getUsername());
            return email;
        }
        LOGGER.warn("Email address [{}] for [{}] is not valid", (Object)email, (Object)query.getUsername());
        return null;
    }

    public String findPhone(PasswordManagementQuery query) {
        return this.findAttribute(query, this.casProperties.getAuthn().getPm().getReset().getSms().getAttributeName(), CollectionUtils.wrap((Object)query.getUsername()));
    }

    public String findUsername(PasswordManagementQuery query) {
        return this.findAttribute(query, this.casProperties.getAuthn().getPm().getLdap().stream().map(LdapPasswordManagementProperties::getUsernameAttribute).collect(Collectors.toList()), CollectionUtils.wrap((Object)query.getEmail()));
    }

    public void updateSecurityQuestions(PasswordManagementQuery query) {
        this.findEntries(CollectionUtils.wrap((Object)query.getUsername()), true).forEach((entry, ldap) -> {
            LOGGER.debug("Located LDAP entry [{}] in the response", entry);
            ArrayDeque questionsAndAnswers = new ArrayDeque(ldap.getSecurityQuestionsAttributes().entrySet());
            LOGGER.debug("Security question attributes are defined to be [{}]", questionsAndAnswers);
            LdapConnectionFactory ldapConnectionFactory = new LdapConnectionFactory(this.connectionFactoryMap.get(ldap.getLdapUrl()));
            LinkedHashMap attributes = new LinkedHashMap();
            query.getSecurityQuestions().forEach((question, answers) -> {
                Map.Entry attrEntry = (Map.Entry)questionsAndAnswers.pop();
                attributes.put((String)attrEntry.getKey(), Set.of(question));
                attributes.put((String)attrEntry.getValue(), Set.copyOf(answers));
            });
            ldapConnectionFactory.executeModifyOperation(entry.getDn(), attributes);
        });
    }

    public boolean unlockAccount(Credential credential) {
        Map<LdapEntry, LdapPasswordManagementProperties> entries = this.findEntries(CollectionUtils.wrap((Object)credential.getId()), true);
        return entries.entrySet().stream().allMatch(entry -> {
            LOGGER.debug("Located LDAP entry [{}] in the response", entry);
            LdapConnectionFactory ldapConnectionFactory = new LdapConnectionFactory(this.connectionFactoryMap.get(((LdapPasswordManagementProperties)entry.getValue()).getLdapUrl()));
            LinkedHashMap<String, Set<String>> attributes = new LinkedHashMap<String, Set<String>>();
            attributes.put(((LdapPasswordManagementProperties)entry.getValue()).getAccountLockedAttribute(), Set.of(((LdapPasswordManagementProperties)entry.getValue()).getAccountUnlockedAttributeValues()));
            return ldapConnectionFactory.executeModifyOperation(((LdapEntry)entry.getKey()).getDn(), attributes);
        });
    }

    public Map<String, String> getSecurityQuestions(PasswordManagementQuery query) {
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        this.findEntries(CollectionUtils.wrap((Object)query.getUsername()), true).forEach((entry, ldap) -> {
            LOGGER.debug("Located LDAP entry [{}] in the response", entry);
            Map questionsAndAnswers = ldap.getSecurityQuestionsAttributes();
            LOGGER.debug("Security question attributes are defined to be [{}]", (Object)questionsAndAnswers);
            questionsAndAnswers.forEach((key, value) -> {
                Pair<String, String> questionAndAnswer = this.getSecurityQuestionAndAnswer((LdapEntry)entry, (LdapPasswordManagementProperties)ldap, (String)key, (String)value);
                String question = (String)questionAndAnswer.getKey();
                String answer = (String)questionAndAnswer.getValue();
                if (StringUtils.isNotBlank((CharSequence)question) && StringUtils.isNotBlank((CharSequence)answer)) {
                    LOGGER.debug("Added security question [{}] with answer [{}]", (Object)question, (Object)answer);
                    results.put(question, answer);
                }
            });
        });
        return results;
    }

    protected Pair<String, String> getSecurityQuestionAndAnswer(LdapEntry entry, LdapPasswordManagementProperties properties, String questionAttributeName, String answerAttributeName) {
        LdapAttribute questionAttribute = entry.getAttribute(questionAttributeName);
        LdapAttribute answerAttribute = entry.getAttribute(answerAttributeName);
        String question = Optional.ofNullable(questionAttribute).map(LdapAttribute::getStringValue).orElse("");
        String answer = Optional.ofNullable(answerAttribute).map(LdapAttribute::getStringValue).orElse("");
        return Pair.of((Object)question, (Object)answer);
    }

    public boolean changeInternal(PasswordChangeRequest bean) {
        List<Boolean> results = this.findEntries(CollectionUtils.wrap((Object)bean.getUsername()), true).entrySet().stream().map(entry -> {
            String dn = ((LdapEntry)entry.getKey()).getDn();
            LOGGER.debug("Updating account password for [{}]", (Object)dn);
            LdapConnectionFactory ldapConnectionFactory = new LdapConnectionFactory(this.connectionFactoryMap.get(((LdapPasswordManagementProperties)entry.getValue()).getLdapUrl()));
            if (ldapConnectionFactory.executePasswordModifyOperation(dn, bean.getCurrentPassword(), bean.getPassword(), ((LdapPasswordManagementProperties)entry.getValue()).getType())) {
                LOGGER.debug("Successfully updated the account password for [{}]", (Object)dn);
                return Boolean.TRUE;
            }
            LOGGER.error("Could not update the LDAP entry's password for [{}]", (Object)dn);
            return Boolean.FALSE;
        }).toList();
        return !results.isEmpty() && results.stream().allMatch(BooleanUtils::isTrue);
    }

    protected String findAttribute(PasswordManagementQuery context, List<String> attributeNames, List<String> ldapFilterParam) {
        return this.findEntries(ldapFilterParam, false).keySet().stream().map(entry -> {
            LOGGER.debug("Found LDAP entry [{}] to use", entry);
            return attributeNames.stream().map(attributeName -> SpringExpressionLanguageValueResolver.getInstance().resolve(attributeName)).map(attributeName -> {
                LdapAttribute attr = entry.getAttribute(attributeName);
                if (attr != null) {
                    String attributeValue = attr.getStringValue();
                    LOGGER.debug("Found [{}] [{}] for user [{}].", new Object[]{attributeName, attributeValue, context.getUsername()});
                    return attributeValue;
                }
                LOGGER.warn("Could not locate LDAP attribute [{}] for [{}]", attributeName, (Object)entry.getDn());
                return null;
            }).filter(Objects::nonNull).findFirst().orElse(null);
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    protected Map<LdapEntry, LdapPasswordManagementProperties> findEntries(List<String> filterValues, boolean transform) {
        LinkedHashMap<LdapEntry, LdapPasswordManagementProperties> results = new LinkedHashMap<LdapEntry, LdapPasswordManagementProperties>();
        this.casProperties.getAuthn().getPm().getLdap().stream().sorted(Comparator.comparing(AbstractLdapProperties::getName)).forEach(Unchecked.consumer(ldap -> {
            ArrayList effectiveFilters = new ArrayList(filterValues);
            if (transform) {
                PrincipalNameTransformer transformer = PrincipalNameTransformerUtils.newPrincipalNameTransformer((PrincipalTransformationProperties)ldap.getPrincipalTransformation());
                effectiveFilters.clear();
                effectiveFilters.addAll(filterValues.stream().map(Unchecked.function(arg_0 -> ((PrincipalNameTransformer)transformer).transform(arg_0))).toList());
            }
            FilterTemplate filter = LdapUtils.newLdaptiveSearchFilter((String)ldap.getSearchFilter(), (String)"user", effectiveFilters);
            LOGGER.debug("Constructed LDAP filter [{}]", (Object)filter);
            LdapConnectionFactory ldapConnectionFactory = new LdapConnectionFactory(this.connectionFactoryMap.get(ldap.getLdapUrl()));
            SearchResponse response = ldapConnectionFactory.executeSearchOperation(ldap.getBaseDn(), filter, ldap.getPageSize());
            LOGGER.debug("LDAP response [{}]", (Object)response);
            if (LdapUtils.containsResultEntry((SearchResponse)response)) {
                results.put(response.getEntry(), (LdapPasswordManagementProperties)ldap);
            }
        }));
        return results;
    }
}

