/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.web.flow;

import java.util.List;
import java.util.Optional;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorTokenCredential;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.configurer.AbstractCasMultifactorWebflowConfigurer;
import org.apereo.cas.web.flow.configurer.CasMultifactorWebflowCustomizer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.action.SetAction;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class GoogleAuthenticatorMultifactorWebflowConfigurer
extends AbstractCasMultifactorWebflowConfigurer {
    public GoogleAuthenticatorMultifactorWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry flowDefinitionRegistry, FlowDefinitionRegistry mfaFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, List<CasMultifactorWebflowCustomizer> mfaFlowCustomizers) {
        super(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties, Optional.of(mfaFlowDefinitionRegistry), mfaFlowCustomizers);
    }

    protected void doInitialize() {
        String providerId = this.casProperties.getAuthn().getMfa().getGauth().getId();
        this.multifactorAuthenticationFlowDefinitionRegistries.forEach(registry -> {
            Flow flow = this.getFlow((FlowDefinitionRegistry)registry, providerId);
            this.createFlowVariable(flow, "credential", GoogleAuthenticatorTokenCredential.class);
            flow.getStartActionList().add((Action)this.createEvaluateAction("initialFlowSetupAction"));
            this.createEndState(flow, "success");
            ActionState initLoginFormState = this.createActionState(flow, "initializeLoginForm", new Action[]{this.createEvaluateAction("prepareGoogleAuthenticatorLoginAction"), this.createEvaluateAction("initializeLoginAction")});
            this.createTransitionForState((TransitionableState)initLoginFormState, "success", "accountRegistrationCheck");
            this.setStartState(flow, (TransitionableState)initLoginFormState);
            ActionState acctRegCheckState = this.createActionState(flow, "accountRegistrationCheck", (Action)this.createEvaluateAction("googleAccountCheckRegistrationAction"));
            this.createTransitionForState((TransitionableState)acctRegCheckState, "register", "viewRegistration");
            this.createTransitionForState((TransitionableState)acctRegCheckState, "confirm", "viewConfirmRegistration");
            this.createTransitionForState((TransitionableState)acctRegCheckState, "success", "viewLoginForm");
            this.createTransitionForState((TransitionableState)acctRegCheckState, "stop", "viewRegistrationRequired");
            this.createViewState(flow, "viewRegistrationRequired", "gauth/casGoogleAuthenticatorRegistrationRequiredView");
            ActionState acctRegSaveState = this.createActionState(flow, "saveRegistrationGoogle", (Action)this.createEvaluateAction("googleSaveAccountRegistrationAction"));
            this.createTransitionForState((TransitionableState)acctRegSaveState, "success", "accountRegistrationCheck");
            this.createStateDefaultTransition((TransitionableState)acctRegSaveState, "accountRegistrationCheck");
            ActionState realSubmitState = this.createActionState(flow, "realSubmit", new Action[]{this.createEvaluateAction("googleValidateSelectedRegistrationAction"), this.createEvaluateAction("oneTimeTokenAuthenticationWebflowAction")});
            this.createTransitionForState((TransitionableState)realSubmitState, "success", "success");
            this.createTransitionForState((TransitionableState)realSubmitState, "error", "viewLoginForm");
            SetAction setPrincipalAction = this.createSetAction("viewScope.principal", "conversationScope.authentication.principal");
            List propertiesToBind = CollectionUtils.wrapList((Object[])new String[]{"token", "accountId"});
            BinderConfiguration binder = this.createStateBinderConfiguration(propertiesToBind);
            ViewState googleLoginFormState = this.createViewState(flow, "viewLoginForm", "gauth/casGoogleAuthenticatorLoginView", binder);
            this.createStateModelBinding((TransitionableState)googleLoginFormState, "credential", GoogleAuthenticatorTokenCredential.class);
            googleLoginFormState.getEntryActionList().add((Action)setPrincipalAction);
            this.createTransitionForState((TransitionableState)googleLoginFormState, "submit", "authorizeTokenAttempt", this.createTransitionAttributes(true, true));
            this.createTransitionForState((TransitionableState)googleLoginFormState, "register", "viewRegistration", this.createTransitionAttributes(false, false));
            this.createTransitionForState((TransitionableState)googleLoginFormState, "confirm", "validateGoogleAccountToken", this.createTransitionAttributes(false, false));
            this.createTransitionForState((TransitionableState)googleLoginFormState, "select", "viewConfirmRegistration", this.createTransitionAttributes(false, false));
            ActionState authorizeTokenState = this.createActionState(flow, "authorizeTokenAttempt", new String[]{"googleAccountAuthorizeTokenAttemptAction"});
            this.createTransitionForState((TransitionableState)authorizeTokenState, "success", "realSubmit");
            this.createTransitionForState((TransitionableState)authorizeTokenState, "error", "googleAccountTokenAuthorizationError");
            this.createViewState(flow, "googleAccountTokenAuthorizationError", "gauth/casGoogleAuthenticatorTokenAuthorizationErrorView");
            ViewState regViewState = this.createViewState(flow, "viewRegistration", "gauth/casGoogleAuthenticatorRegistrationView");
            regViewState.getEntryActionList().addAll(new Action[]{setPrincipalAction, this.createEvaluateAction("googleAccountCreateRegistrationAction")});
            this.createTransitionForState((TransitionableState)regViewState, "submit", "saveRegistrationGoogle");
            ViewState confirmRegViewState = this.createViewState(flow, "viewConfirmRegistration", "gauth/casGoogleAuthenticatorConfirmRegistrationView");
            confirmRegViewState.getEntryActionList().add((Action)setPrincipalAction);
            confirmRegViewState.getEntryActionList().add((Action)this.createEvaluateAction("prepareGoogleAuthenticatorLoginAction"));
            this.createTransitionForState((TransitionableState)confirmRegViewState, "register", "viewRegistration", new String[]{"googleAccountConfirmRegistrationAction"});
            this.createTransitionForState((TransitionableState)confirmRegViewState, "delete", "googleAccountDeleteDevice");
            this.createTransitionForState((TransitionableState)confirmRegViewState, "select", "viewLoginForm", new String[]{"googleAccountConfirmSelectionAction"});
            ActionState deleteDeviceState = this.createActionState(flow, "googleAccountDeleteDevice", new String[]{"googleAccountDeleteDeviceAction"});
            this.createTransitionForState((TransitionableState)deleteDeviceState, "success", acctRegCheckState.getId());
            ActionState confirmTokenState = this.createActionState(flow, "validateGoogleAccountToken", new String[]{"googleValidateTokenAction"});
            this.createTransitionForState((TransitionableState)confirmTokenState, "success", regViewState.getId());
            this.createTransitionForState((TransitionableState)confirmTokenState, "error", googleLoginFormState.getId());
        });
        this.registerMultifactorProviderAuthenticationWebflow(this.getLoginFlow(), providerId, providerId);
    }
}

