/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.gauth.CasGoogleAuthenticator;
import org.apereo.cas.gauth.credential.BaseGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.concurrent.CasReentrantLock;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class JsonGoogleAuthenticatorTokenCredentialRepository
extends BaseGoogleAuthenticatorTokenCredentialRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonGoogleAuthenticatorTokenCredentialRepository.class);
    private final CasReentrantLock lock = new CasReentrantLock();
    private final Resource location;
    private final StringSerializer<Map<String, List<OneTimeTokenAccount>>> serializer;

    public JsonGoogleAuthenticatorTokenCredentialRepository(Resource location, CasGoogleAuthenticator googleAuthenticator, CipherExecutor<String, String> tokenCredentialCipher, CipherExecutor<Number, Number> scratchCodesCipher, StringSerializer<Map<String, List<OneTimeTokenAccount>>> serializer) {
        super(tokenCredentialCipher, scratchCodesCipher, googleAuthenticator);
        this.location = location;
        this.serializer = serializer;
    }

    public OneTimeTokenAccount get(long id) {
        return (OneTimeTokenAccount)this.lock.tryLock(() -> {
            Map<String, List<OneTimeTokenAccount>> accounts = this.readAccountsFromJsonRepository();
            return accounts.values().stream().flatMap(Collection::stream).filter(ac -> ac.getId() == id).findFirst().map(x$0 -> this.decode((OneTimeTokenAccount)x$0)).orElse(null);
        });
    }

    public OneTimeTokenAccount get(String username, long id) {
        return (OneTimeTokenAccount)this.lock.tryLock(() -> this.get(username).stream().filter(ac -> ac.getId() == id).findFirst().map(x$0 -> this.decode((OneTimeTokenAccount)x$0)).orElse(null));
    }

    public Collection<? extends OneTimeTokenAccount> get(String username) {
        return (Collection)this.lock.tryLock(() -> {
            try {
                if (!this.location.getFile().exists()) {
                    LOGGER.warn("JSON account repository file [{}] is not found.", (Object)this.location.getFile());
                    return new ArrayList();
                }
                if (this.location.getFile().length() <= 0L) {
                    LOGGER.debug("JSON account repository file location [{}] is empty.", (Object)this.location.getFile());
                    return new ArrayList();
                }
                Map map = (Map)this.serializer.from(this.location.getFile());
                if (map == null) {
                    LOGGER.debug("JSON account repository file [{}] is empty.", (Object)this.location.getFile());
                    return new ArrayList();
                }
                List account = (List)map.get(username.trim().toLowerCase(Locale.ENGLISH));
                if (account != null) {
                    return this.decode(account);
                }
            }
            catch (Exception e) {
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            }
            return new ArrayList();
        });
    }

    public Collection<? extends OneTimeTokenAccount> load() {
        return (Collection)this.lock.tryLock(() -> {
            try {
                return this.readAccountsFromJsonRepository().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            }
            catch (Exception e) {
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
                return new ArrayList();
            }
        });
    }

    public OneTimeTokenAccount save(OneTimeTokenAccount account) {
        return (OneTimeTokenAccount)this.lock.tryLock(() -> {
            try {
                account.assignIdIfNecessary();
                LOGGER.debug("Storing google authenticator account for [{}]", (Object)account.getUsername());
                Map<String, List<OneTimeTokenAccount>> accounts = this.readAccountsFromJsonRepository();
                LOGGER.debug("Found [{}] account(s) and added google authenticator account for [{}]", (Object)accounts.size(), (Object)account.getUsername());
                OneTimeTokenAccount encoded = this.encode(account);
                List records = accounts.getOrDefault(account.getUsername().trim().toLowerCase(Locale.ENGLISH), new ArrayList());
                records.add(encoded);
                accounts.put(account.getUsername().trim().toLowerCase(Locale.ENGLISH), records);
                this.writeAccountsToJsonRepository(accounts);
                return encoded;
            }
            catch (Exception e) {
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
                return null;
            }
        });
    }

    public OneTimeTokenAccount update(OneTimeTokenAccount account) {
        return (OneTimeTokenAccount)this.lock.tryLock(() -> {
            try {
                Map<String, List<OneTimeTokenAccount>> accounts = this.readAccountsFromJsonRepository();
                if (accounts.containsKey(account.getUsername().trim().toLowerCase(Locale.ENGLISH))) {
                    List<OneTimeTokenAccount> records = accounts.get(account.getUsername().trim().toLowerCase(Locale.ENGLISH));
                    return records.stream().filter(rec -> rec.getId() == account.getId()).findFirst().map(act -> {
                        OneTimeTokenAccount encoded = this.encode(account);
                        act.setSecretKey(encoded.getSecretKey());
                        act.setScratchCodes(encoded.getScratchCodes());
                        act.setValidationCode(encoded.getValidationCode());
                        act.setProperties(encoded.getProperties());
                        this.writeAccountsToJsonRepository(accounts);
                        return encoded;
                    }).orElse(null);
                }
            }
            catch (Exception e) {
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            }
            return null;
        });
    }

    public void deleteAll() {
        this.lock.tryLock(__ -> this.writeAccountsToJsonRepository(new HashMap<String, List<OneTimeTokenAccount>>()));
    }

    public void delete(String username) {
        this.lock.tryLock(__ -> {
            Map<String, List<OneTimeTokenAccount>> accounts = this.readAccountsFromJsonRepository();
            accounts.remove(username.trim().toLowerCase(Locale.ENGLISH));
            this.writeAccountsToJsonRepository(accounts);
        });
    }

    public void delete(long id) {
        this.lock.tryLock(__ -> {
            Map<String, List<OneTimeTokenAccount>> accounts = this.readAccountsFromJsonRepository();
            accounts.forEach((key, value) -> value.removeIf(d -> d.getId() == id));
            this.writeAccountsToJsonRepository(accounts);
        });
    }

    public long count() {
        return ((Integer)this.lock.tryLock(() -> {
            Map<String, List<OneTimeTokenAccount>> accounts = this.readAccountsFromJsonRepository();
            return accounts.size();
        })).intValue();
    }

    public long count(String username) {
        return ((Integer)this.lock.tryLock(() -> {
            Map<String, List<OneTimeTokenAccount>> accounts = this.readAccountsFromJsonRepository();
            return accounts.containsKey(username.trim().toLowerCase(Locale.ENGLISH)) ? accounts.get(username.trim().toLowerCase(Locale.ENGLISH)).size() : 0;
        })).intValue();
    }

    private void writeAccountsToJsonRepository(Map<String, List<OneTimeTokenAccount>> accounts) {
        FunctionUtils.doUnchecked(__ -> {
            if (this.location.getFile() != null) {
                LOGGER.debug("Saving [{}] google authenticator accounts to JSON file at [{}]", (Object)accounts.size(), (Object)this.location.getFile());
                this.serializer.to(this.location.getFile(), (Object)accounts);
            }
        }, (Object[])new Object[0]);
    }

    private Map<String, List<OneTimeTokenAccount>> readAccountsFromJsonRepository() {
        return (Map)FunctionUtils.doUnchecked(() -> {
            boolean result;
            File file = this.location.getFile();
            LOGGER.debug("Ensuring JSON repository file exists at [{}]", (Object)file);
            boolean bl = result = file != null && file.createNewFile();
            if (result) {
                LOGGER.debug("Created JSON repository file at [{}]", (Object)file);
            }
            if (file != null && file.length() > 0L) {
                LOGGER.debug("Reading JSON repository file at [{}]", (Object)file);
                Map accounts = (Map)this.serializer.from(file);
                LOGGER.debug("Read [{}] accounts from JSON repository file at [{}]", (Object)accounts.size(), (Object)file);
                return accounts;
            }
            return new HashMap();
        });
    }

    @Generated
    public CasReentrantLock getLock() {
        return this.lock;
    }

    @Generated
    public Resource getLocation() {
        return this.location;
    }

    @Generated
    public StringSerializer<Map<String, List<OneTimeTokenAccount>>> getSerializer() {
        return this.serializer;
    }
}

