/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.web.flow.OidcCasWebflowLoginContextProvider;
import org.apereo.cas.oidc.web.flow.OidcRegisteredServiceUIAction;
import org.apereo.cas.oidc.web.flow.OidcUnmetAuthenticationRequirementWebflowExceptionHandler;
import org.apereo.cas.oidc.web.flow.OidcWebflowConfigurer;
import org.apereo.cas.oidc.web.flow.account.OidcAccountProfileAccessTokenAction;
import org.apereo.cas.oidc.web.flow.account.OidcAccountProfileRemoveAccessTokenAction;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.CasWebflowLoginContextProvider;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionHandler;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.resolver.impl.mfa.DefaultMultifactorAuthenticationProviderWebflowEventResolver;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.OpenIDConnect})
@Configuration(value="OidcWebflowConfiguration", proxyBeanMethods=false)
class OidcWebflowConfiguration {
    OidcWebflowConfiguration() {
    }

    @ConditionalOnMissingBean(name={"oidcUnmetAuthenticationRequirementWebflowExceptionHandler"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasWebflowExceptionHandler oidcUnmetAuthenticationRequirementWebflowExceptionHandler(@Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
        return new OidcUnmetAuthenticationRequirementWebflowExceptionHandler(oidcConfigurationContext);
    }

    @ConditionalOnMissingBean(name={"oidcCasWebflowExecutionPlanConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasWebflowExecutionPlanConfigurer oidcCasWebflowExecutionPlanConfigurer(@Qualifier(value="oidcWebflowConfigurer") CasWebflowConfigurer oidcWebflowConfigurer, @Qualifier(value="oidcLocaleChangeInterceptor") HandlerInterceptor oidcLocaleChangeInterceptor, @Qualifier(value="oidcCasWebflowLoginContextProvider") CasWebflowLoginContextProvider oidcCasWebflowLoginContextProvider) {
        return plan -> {
            plan.registerWebflowConfigurer(oidcWebflowConfigurer);
            plan.registerWebflowInterceptor(oidcLocaleChangeInterceptor);
            plan.registerWebflowLoginContextProvider(oidcCasWebflowLoginContextProvider);
        };
    }

    @Bean
    @ConditionalOnMissingBean(name={"oidcCasWebflowLoginContextProvider"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasWebflowLoginContextProvider oidcCasWebflowLoginContextProvider(@Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor) {
        return new OidcCasWebflowLoginContextProvider(argumentExtractor);
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @Lazy(value=false)
    public CasWebflowEventResolver oidcAuthenticationContextWebflowEventResolver(@Qualifier(value="initialAuthenticationAttemptWebflowEventResolver") CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext, @Qualifier(value="oidcMultifactorAuthenticationTrigger") MultifactorAuthenticationTrigger oidcMultifactorAuthenticationTrigger) {
        DefaultMultifactorAuthenticationProviderWebflowEventResolver resolver = new DefaultMultifactorAuthenticationProviderWebflowEventResolver(casWebflowConfigurationContext, oidcMultifactorAuthenticationTrigger);
        initialAuthenticationAttemptWebflowEventResolver.addDelegate((CasWebflowEventResolver)resolver);
        return resolver;
    }

    @ConditionalOnMissingBean(name={"oidcWebflowConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasWebflowConfigurer oidcWebflowConfigurer(@Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, @Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return new OidcWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
    }

    @ConditionalOnMissingBean(name={"oidcRegisteredServiceUIAction"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public Action oidcRegisteredServiceUIAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="oauth20AuthenticationRequestServiceSelectionStrategy") AuthenticationServiceSelectionStrategy oauth20AuthenticationServiceSelectionStrategy, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
        return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new OidcRegisteredServiceUIAction(servicesManager, oauth20AuthenticationServiceSelectionStrategy)).withId("oidcRegisteredServiceUIAction").build().get();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"oidcAccountProfileAccessTokensAction"})
    public Action oidcAccountProfileAccessTokensAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry) {
        return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new OidcAccountProfileAccessTokenAction(ticketRegistry)).withId("oidcAccountProfileAccessTokensAction").build().get();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"accountProfileOidcRemoveAccessTokenAction"})
    public Action accountProfileOidcRemoveAccessTokenAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry) {
        return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new OidcAccountProfileRemoveAccessTokenAction(ticketRegistry)).withId("accountProfileOidcRemoveAccessTokenAction").build().get();
    }
}

