/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.dao;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.group.Group;

public class AllowedSchemas<S extends Schema> {
    private final Set<S> self = new HashSet<S>();
    private final Map<Group, Set<S>> memberships = new HashMap<Group, Set<S>>();
    private final Map<RelationshipType, Set<S>> relationshipTypes = new HashMap<RelationshipType, Set<S>>();

    public Set<S> self() {
        return this.self;
    }

    public Set<S> membership(Group group) {
        return Optional.ofNullable(this.memberships.get(group)).orElseGet(Set::of);
    }

    public Map<Group, Set<S>> memberships() {
        return this.memberships;
    }

    public Set<S> relationshipType(RelationshipType relationshipType) {
        return Optional.ofNullable(this.relationshipTypes.get(relationshipType)).orElseGet(Set::of);
    }

    public Map<RelationshipType, Set<S>> relationshipTypes() {
        return this.relationshipTypes;
    }

    public boolean selfContains(S schema) {
        return this.self.contains(schema);
    }

    public boolean selfContains(String schema) {
        return this.self.stream().anyMatch(s -> s.getKey().equals(schema));
    }

    public boolean membershipsContains(Group group, S schema) {
        return this.membership(group).contains(schema);
    }

    public boolean membershipsContains(Group group, String schema) {
        return this.membership(group).stream().anyMatch(s -> s.getKey().equals(schema));
    }

    public boolean relationshipTypesContains(RelationshipType relationshipType, S schema) {
        return this.relationshipType(relationshipType).contains(schema);
    }

    public boolean relationshipTypesContains(RelationshipType relationshipType, String schema) {
        return this.relationshipType(relationshipType).stream().anyMatch(s -> s.getKey().equals(schema));
    }
}

