/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.openjpa;

import java.io.Serializable;
import java.util.List;
import org.apache.openjpa.event.RemoteCommitEvent;
import org.apache.openjpa.event.RemoteCommitListener;
import org.apache.openjpa.util.StringId;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAConnInstance;
import org.apache.syncope.core.persistence.jpa.entity.JPAExternalResource;
import org.apache.syncope.core.provisioning.api.ConnectorManager;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorManagerRemoteCommitListener
implements RemoteCommitListener,
Serializable {
    private static final long serialVersionUID = 5260753255454140460L;
    protected static final Logger LOG = LoggerFactory.getLogger(ConnectorManagerRemoteCommitListener.class);
    protected final ConnectorManager connectorManager;
    protected final ExternalResourceDAO resourceDAO;
    protected final String domain;

    public ConnectorManagerRemoteCommitListener(ConnectorManager connectorManager, ExternalResourceDAO resourceDAO, String domain) {
        this.connectorManager = connectorManager;
        this.resourceDAO = resourceDAO;
        this.domain = domain;
    }

    protected void registerForExternalResource(String resourceKey) {
        AuthContextUtils.runAsAdmin((String)this.domain, () -> this.resourceDAO.findById(resourceKey).ifPresentOrElse(resource -> {
            try {
                this.connectorManager.registerConnector(resource);
            }
            catch (Exception e) {
                LOG.error("While registering connector for resource {}", (Object)resourceKey, (Object)e);
            }
        }, () -> LOG.debug("No resource found for '{}', ignoring", (Object)resourceKey)));
    }

    protected void registerForConnInstance(String connInstanceKey) {
        AuthContextUtils.runAsAdmin((String)this.domain, () -> {
            List resources = this.resourceDAO.findByConnInstance(connInstanceKey);
            if (resources.isEmpty()) {
                LOG.debug("No resources found for connInstance '{}', ignoring", (Object)connInstanceKey);
            }
            resources.forEach(resource -> {
                try {
                    this.connectorManager.registerConnector(resource);
                }
                catch (Exception e) {
                    LOG.error("While registering connector {} for resource {}", new Object[]{connInstanceKey, resource, e});
                }
            });
        });
    }

    protected void unregister(String resourceKey) {
        AuthContextUtils.runAsAdmin((String)this.domain, () -> this.resourceDAO.findById(resourceKey).ifPresentOrElse(resource -> {
            try {
                this.connectorManager.unregisterConnector(resource);
            }
            catch (Exception e) {
                LOG.error("While unregistering connector for resource {}", (Object)resourceKey, (Object)e);
            }
        }, () -> LOG.debug("No resource found for '{}', ignoring", (Object)resourceKey)));
    }

    public void afterCommit(RemoteCommitEvent event) {
        if (event.getPayloadType() == 1) {
            event.getPersistedObjectIds().stream().filter(StringId.class::isInstance).map(StringId.class::cast).forEach(id -> {
                if (JPAExternalResource.class.isAssignableFrom(id.getType())) {
                    this.registerForExternalResource(id.getId());
                } else if (JPAConnInstance.class.isAssignableFrom(id.getType())) {
                    this.registerForConnInstance(id.getId());
                }
            });
        }
        if (event.getPayloadType() != 2) {
            event.getUpdatedObjectIds().stream().filter(StringId.class::isInstance).map(StringId.class::cast).forEach(id -> {
                if (JPAExternalResource.class.isAssignableFrom(id.getType())) {
                    this.registerForExternalResource(id.getId());
                } else if (JPAConnInstance.class.isAssignableFrom(id.getType())) {
                    this.registerForConnInstance(id.getId());
                }
            });
            event.getDeletedObjectIds().stream().filter(StringId.class::isInstance).map(StringId.class::cast).forEach(id -> {
                if (JPAExternalResource.class.isAssignableFrom(id.getType())) {
                    this.unregister(id.getId());
                }
            });
        }
    }

    public void close() {
    }
}

