/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import jakarta.persistence.Cacheable;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.RelationshipTypeExtension;
import org.apache.syncope.core.persistence.common.validation.RelationshipTypeCheck;
import org.apache.syncope.core.persistence.jpa.entity.AbstractProvidedKeyEntity;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyType;
import org.apache.syncope.core.persistence.jpa.entity.JPARelationshipTypeExtension;

@Entity
@Table(name="RelationshipType")
@RelationshipTypeCheck
@Cacheable
public class JPARelationshipType
extends AbstractProvidedKeyEntity
implements RelationshipType,
PersistenceCapable {
    private static final long serialVersionUID = -753673974614737065L;
    public static final String TABLE = "RelationshipType";
    private String description;
    @NotNull
    @ManyToOne
    private JPAAnyType leftEndAnyType;
    @NotNull
    @ManyToOne
    private JPAAnyType rightEndAnyType;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER, mappedBy="relationshipType")
    private List<JPARelationshipTypeExtension> typeExtensions = new ArrayList<JPARelationshipTypeExtension>();
    private static int pcInheritedFieldCount = AbstractProvidedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public String getDescription() {
        return JPARelationshipType.pcGetdescription(this);
    }

    public void setDescription(String description) {
        JPARelationshipType.pcSetdescription(this, description);
    }

    public AnyType getLeftEndAnyType() {
        return JPARelationshipType.pcGetleftEndAnyType(this);
    }

    public void setLeftEndAnyType(AnyType anyType) {
        this.checkType(anyType, JPAAnyType.class);
        JPARelationshipType.pcSetleftEndAnyType(this, (JPAAnyType)anyType);
    }

    public AnyType getRightEndAnyType() {
        return JPARelationshipType.pcGetrightEndAnyType(this);
    }

    public void setRightEndAnyType(AnyType anyType) {
        this.checkType(anyType, JPAAnyType.class);
        JPARelationshipType.pcSetrightEndAnyType(this, (JPAAnyType)anyType);
    }

    public boolean add(RelationshipTypeExtension typeExtension) {
        this.checkType(typeExtension, JPARelationshipTypeExtension.class);
        return JPARelationshipType.pcGettypeExtensions(this).add((JPARelationshipTypeExtension)typeExtension);
    }

    public Optional<? extends RelationshipTypeExtension> getTypeExtension(AnyType anyType) {
        return JPARelationshipType.pcGettypeExtensions(this).stream().filter(typeExtension -> typeExtension.getAnyType().equals((Object)anyType)).findFirst();
    }

    public List<? extends RelationshipTypeExtension> getTypeExtensions() {
        return JPARelationshipType.pcGettypeExtensions(this);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 255933283;
    }

    static {
        pcPCSuperclass = AbstractProvidedKeyEntity.class;
        pcFieldNames = new String[]{"description", "leftEndAnyType", "rightEndAnyType", "typeExtensions"};
        pcFieldTypes = new Class[]{String.class, JPAAnyType.class, JPAAnyType.class, List.class};
        pcFieldFlags = new byte[]{26, 26, 26, 10};
        PCRegistry.register(JPARelationshipType.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPARelationshipType", (PersistenceCapable)new JPARelationshipType());
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.description = null;
        this.leftEndAnyType = null;
        this.rightEndAnyType = null;
        this.typeExtensions = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPARelationshipType jPARelationshipType = new JPARelationshipType();
        if (bl) {
            jPARelationshipType.pcClearFields();
        }
        jPARelationshipType.pcStateManager = stateManager;
        jPARelationshipType.pcCopyKeyFieldsFromObjectId(object);
        return jPARelationshipType;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPARelationshipType jPARelationshipType = new JPARelationshipType();
        if (bl) {
            jPARelationshipType.pcClearFields();
        }
        jPARelationshipType.pcStateManager = stateManager;
        return jPARelationshipType;
    }

    protected static int pcGetManagedFieldCount() {
        return 4 + AbstractProvidedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.description = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.leftEndAnyType = (JPAAnyType)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.rightEndAnyType = (JPAAnyType)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.typeExtensions = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.description);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.leftEndAnyType);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.rightEndAnyType);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.typeExtensions);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPARelationshipType jPARelationshipType, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPARelationshipType, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.description = jPARelationshipType.description;
                return;
            }
            case 1: {
                this.leftEndAnyType = jPARelationshipType.leftEndAnyType;
                return;
            }
            case 2: {
                this.rightEndAnyType = jPARelationshipType.rightEndAnyType;
                return;
            }
            case 3: {
                this.typeExtensions = jPARelationshipType.typeExtensions;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPARelationshipType jPARelationshipType = (JPARelationshipType)object;
        if (jPARelationshipType.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPARelationshipType, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPARelationshipType.class;
    }

    private static final String pcGetdescription(JPARelationshipType jPARelationshipType) {
        if (jPARelationshipType.pcStateManager == null) {
            return jPARelationshipType.description;
        }
        int n = pcInheritedFieldCount + 0;
        jPARelationshipType.pcStateManager.accessingField(n);
        return jPARelationshipType.description;
    }

    private static final void pcSetdescription(JPARelationshipType jPARelationshipType, String string) {
        if (jPARelationshipType.pcStateManager == null) {
            jPARelationshipType.description = string;
            return;
        }
        jPARelationshipType.pcStateManager.settingStringField((PersistenceCapable)jPARelationshipType, pcInheritedFieldCount + 0, jPARelationshipType.description, string, 0);
    }

    private static final JPAAnyType pcGetleftEndAnyType(JPARelationshipType jPARelationshipType) {
        if (jPARelationshipType.pcStateManager == null) {
            return jPARelationshipType.leftEndAnyType;
        }
        int n = pcInheritedFieldCount + 1;
        jPARelationshipType.pcStateManager.accessingField(n);
        return jPARelationshipType.leftEndAnyType;
    }

    private static final void pcSetleftEndAnyType(JPARelationshipType jPARelationshipType, JPAAnyType jPAAnyType) {
        if (jPARelationshipType.pcStateManager == null) {
            jPARelationshipType.leftEndAnyType = jPAAnyType;
            return;
        }
        jPARelationshipType.pcStateManager.settingObjectField((PersistenceCapable)jPARelationshipType, pcInheritedFieldCount + 1, (Object)jPARelationshipType.leftEndAnyType, (Object)jPAAnyType, 0);
    }

    private static final JPAAnyType pcGetrightEndAnyType(JPARelationshipType jPARelationshipType) {
        if (jPARelationshipType.pcStateManager == null) {
            return jPARelationshipType.rightEndAnyType;
        }
        int n = pcInheritedFieldCount + 2;
        jPARelationshipType.pcStateManager.accessingField(n);
        return jPARelationshipType.rightEndAnyType;
    }

    private static final void pcSetrightEndAnyType(JPARelationshipType jPARelationshipType, JPAAnyType jPAAnyType) {
        if (jPARelationshipType.pcStateManager == null) {
            jPARelationshipType.rightEndAnyType = jPAAnyType;
            return;
        }
        jPARelationshipType.pcStateManager.settingObjectField((PersistenceCapable)jPARelationshipType, pcInheritedFieldCount + 2, (Object)jPARelationshipType.rightEndAnyType, (Object)jPAAnyType, 0);
    }

    private static final List pcGettypeExtensions(JPARelationshipType jPARelationshipType) {
        if (jPARelationshipType.pcStateManager == null) {
            return jPARelationshipType.typeExtensions;
        }
        int n = pcInheritedFieldCount + 3;
        jPARelationshipType.pcStateManager.accessingField(n);
        return jPARelationshipType.typeExtensions;
    }

    private static final void pcSettypeExtensions(JPARelationshipType jPARelationshipType, List list) {
        if (jPARelationshipType.pcStateManager == null) {
            jPARelationshipType.typeExtensions = list;
            return;
        }
        jPARelationshipType.pcStateManager.settingObjectField((PersistenceCapable)jPARelationshipType, pcInheritedFieldCount + 3, jPARelationshipType.typeExtensions, (Object)list, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

