/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.PagedConnObjectResult;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.rest.api.beans.ConnObjectTOQuery;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="Resources")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="resources")
public interface ResourceService
extends JAXRSService {
    @ApiResponses(value={@ApiResponse(responseCode="201", description="connObjectKey value for the external resource, for the given type and key", headers={@Header(name="X-Syncope-ConnObject-Key", schema=@Schema(type="string"), description="connObjectKey value for the external resource, for the given type and key")}), @ApiResponse(responseCode="404", description="user, group or any object not found, or connObjectKey cannot be calculated")})
    @OPTIONS
    @Path(value="{key}/{anyTypeKey}/{anyKey}")
    public Response getConnObjectKeyValue(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="anyTypeKey") String var2, @NotNull @PathParam(value="anyKey") String var3);

    @GET
    @Path(value="{key}/{anyTypeKey}/{value}")
    @Produces(value={"application/json"})
    public ConnObject readConnObject(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="anyTypeKey") String var2, @NotNull @PathParam(value="value") String var3);

    @GET
    @Path(value="{key}/{anyTypeKey}")
    @Produces(value={"application/json"})
    public PagedConnObjectResult searchConnObjects(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="anyTypeKey") String var2, @BeanParam ConnObjectTOQuery var3);

    @GET
    @Path(value="{key}")
    @Produces(value={"application/json"})
    public ResourceTO read(@NotNull @PathParam(value="key") String var1);

    @GET
    @Produces(value={"application/json"})
    public List<ResourceTO> list();

    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource successfully created", headers={@Header(name="X-Syncope-Key", schema=@Schema(type="string"), description="Key value for the entity created"), @Header(name="Location", schema=@Schema(type="string"), description="URL of the entity created")})})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(@NotNull ResourceTO var1);

    @Parameter(name="key", description="Resource's key", in=ParameterIn.PATH, schema=@Schema(type="string"))
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @PUT
    @Path(value="{key}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void update(@NotNull ResourceTO var1);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @POST
    @Path(value="{key}/{anyTypeKey}")
    @Produces(value={"application/json"})
    public void setLatestSyncToken(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="anyTypeKey") String var2);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @DELETE
    @Path(value="{key}/{anyTypeKey}")
    @Produces(value={"application/json"})
    public void removeSyncToken(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="anyTypeKey") String var2);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @DELETE
    @Path(value="{key}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void delete(@NotNull @PathParam(value="key") String var1);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @POST
    @Path(value="check")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public void check(@NotNull ResourceTO var1);
}

