/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import org.ldaptive.AbstractFreezable;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.transport.ThreadPoolConfig;
import org.ldaptive.transport.Transport;
import org.ldaptive.transport.TransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnectionFactory
extends AbstractFreezable
implements ConnectionFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Transport transport;
    private ConnectionConfig config;

    public DefaultConnectionFactory() {
        this(TransportFactory.getTransport(ThreadPoolConfig.singleIoThread("default", ThreadPoolConfig.ShutdownStrategy.CONNECTION_CLOSE)));
    }

    public DefaultConnectionFactory(Transport t) {
        this.transport = t;
    }

    public DefaultConnectionFactory(String ldapUrl) {
        this(new ConnectionConfig(ldapUrl));
    }

    public DefaultConnectionFactory(String ldapUrl, Transport t) {
        this(new ConnectionConfig(ldapUrl), t);
    }

    public DefaultConnectionFactory(ConnectionConfig cc) {
        this(cc, TransportFactory.getTransport(ThreadPoolConfig.singleIoThread("default", ThreadPoolConfig.ShutdownStrategy.CONNECTION_CLOSE)));
    }

    public DefaultConnectionFactory(ConnectionConfig cc, Transport t) {
        this.transport = t;
        this.setConnectionConfig(cc);
    }

    @Override
    public void freeze() {
        super.freeze();
        DefaultConnectionFactory.freeze(this.config);
    }

    @Override
    public ConnectionConfig getConnectionConfig() {
        return this.config;
    }

    public void setConnectionConfig(ConnectionConfig cc) {
        this.assertMutable();
        if (cc == null) {
            throw new IllegalArgumentException("Connection config cannot be null");
        }
        this.config = cc;
        this.config.freeze();
    }

    public Transport getTransport() {
        return this.transport;
    }

    @Override
    public Connection getConnection() {
        return this.transport.create(this.config);
    }

    @Override
    public void close() {
        this.transport.close();
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::transport=" + String.valueOf(this.transport) + ", config=" + String.valueOf(this.config) + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Transport t) {
        return new Builder(t);
    }

    public static class Builder {
        private final DefaultConnectionFactory object;

        protected Builder() {
            this.object = new DefaultConnectionFactory();
        }

        protected Builder(Transport t) {
            this.object = new DefaultConnectionFactory(t);
        }

        public Builder freeze() {
            this.object.freeze();
            return this;
        }

        public Builder config(ConnectionConfig cc) {
            this.object.setConnectionConfig(cc);
            return this;
        }

        public DefaultConnectionFactory build() {
            return this.object;
        }
    }
}

