/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.credentials.authenticator;

import com.github.scribejava.core.exceptions.OAuthException;
import java.util.Optional;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class OAuthAuthenticator
implements Authenticator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected OAuthConfiguration configuration;
    protected IndirectClient client;

    protected OAuthAuthenticator(OAuthConfiguration configuration, IndirectClient client) {
        CommonHelper.assertNotNull((String)"client", (Object)client);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        this.configuration = configuration;
        this.client = client;
    }

    public Optional<Credentials> validate(CallContext ctx, Credentials credentials) {
        try {
            this.retrieveAccessToken(ctx.webContext(), credentials);
        }
        catch (OAuthException e) {
            throw new TechnicalException((Throwable)e);
        }
        return Optional.of(credentials);
    }

    protected abstract void retrieveAccessToken(WebContext var1, Credentials var2);
}

