/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.web.config;

import com.giffing.wicket.spring.boot.starter.web.config.WicketWebInitializerConfig;
import com.giffing.wicket.spring.boot.starter.web.servlet.standard.StandardWicketWebInitializer;
import com.giffing.wicket.spring.boot.starter.web.servlet.websocket.DummyWicketSessionResolver;
import com.giffing.wicket.spring.boot.starter.web.servlet.websocket.WebSocketMessageSenderDefault;
import com.giffing.wicket.spring.boot.starter.web.servlet.websocket.WebSocketWicketWebInitializer;
import com.giffing.wicket.spring.boot.starter.web.servlet.websocket.WicketServerEndpointConfigRegister;
import com.giffing.wicket.spring.boot.starter.web.servlet.websocket.WicketSessionResolver;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.ws.javax.JavaxWebSocketFilter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WicketWebInitializerAutoConfig {

    @Configuration
    @ConditionalOnClass(value={JavaxWebSocketFilter.class})
    @ConditionalOnProperty(prefix="wicket.external.websocket", value={"enabled"}, matchIfMissing=true)
    public static class WebSocketWicketWebInitializerAutoConfiguration {
        public static final String REGISTER_SERVER_ENDPOINT = "wicket.external.websocket.registerServerEndpoint";
        public static final String REGISTER_SERVER_ENDPOINT_ENABLED = "wicket.external.websocket.registerServerEndpoint.enabled";

        @Bean
        public WicketWebInitializerConfig wicketWebInitializerConfig() {
            return new WebSocketWicketWebInitializer();
        }

        @Bean
        @ConditionalOnProperty(prefix="wicket.external.websocket.registerServerEndpoint", value={"enabled"}, matchIfMissing=true)
        public WicketServerEndpointConfigRegister wicketServerEndpointConfigRegister() {
            return new WicketServerEndpointConfigRegister();
        }

        @Bean
        @ConditionalOnMissingBean(value={WicketSessionResolver.class})
        public WicketSessionResolver dummyWicketSessionResolver() {
            return new DummyWicketSessionResolver();
        }

        @Bean
        public WebSocketMessageSenderDefault webSocketEventHandler(Application application, WicketSessionResolver wicketSessionResolver) {
            return new WebSocketMessageSenderDefault(application, wicketSessionResolver);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={WicketWebInitializerConfig.class})
    @AutoConfigureAfter(value={WebSocketWicketWebInitializerAutoConfiguration.class})
    public static class StandardWicketWebInitializerAutoConfiguration {
        @Bean
        public WicketWebInitializerConfig wicketWebInitializerConfig() {
            return new StandardWicketWebInitializer();
        }
    }
}

