/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.json.converter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.flowable.eventregistry.json.converter.ChannelValidator;
import org.flowable.eventregistry.json.converter.FlowableEventJsonException;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.OutboundChannelModel;

public class OutboundChannelModelValidator
implements ChannelValidator {
    protected Set<String> supportedSerializers;

    public OutboundChannelModelValidator() {
        this.supportedSerializers = new HashSet<String>();
        this.supportedSerializers.add("json");
        this.supportedSerializers.add("xml");
        this.supportedSerializers.add("expression");
    }

    public OutboundChannelModelValidator(Collection<String> supportedSerializers) {
        this.supportedSerializers = new HashSet<String>(supportedSerializers);
    }

    @Override
    public void validateChannel(ChannelModel channelModel) {
        if (channelModel instanceof OutboundChannelModel) {
            OutboundChannelModel outboundChannelModel = (OutboundChannelModel)channelModel;
            this.validateChannel(outboundChannelModel);
        }
    }

    protected void validateChannel(OutboundChannelModel outboundChannelModel) {
        String serializerType = outboundChannelModel.getSerializerType();
        if (StringUtils.isEmpty((CharSequence)outboundChannelModel.getPipelineDelegateExpression()) && !this.supportedSerializers.contains(serializerType)) {
            throw new FlowableEventJsonException("The serializer type is not supported " + serializerType + " for the channel model with key " + outboundChannelModel.getKey());
        }
    }
}

