/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.notifications.sms;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.CollectionUtils;

public class SmsRequest {
    private final Principal principal;
    private final String attribute;
    private final String text;
    private final String from;
    private final List<String> to;
    private final String tenant;

    public boolean hasAttributeValue() {
        return StringUtils.isNotBlank((CharSequence)this.attribute) && this.principal.getAttributes().containsKey(this.attribute);
    }

    public List<String> getAttributeValue() {
        List value = (List)this.principal.getAttributes().get(this.attribute);
        return (List)CollectionUtils.toCollection((Object)value, ArrayList.class);
    }

    public List<String> getRecipients() {
        return this.hasAttributeValue() ? this.getAttributeValue() : (List)ObjectUtils.getIfNull(this.getTo(), List.of());
    }

    public boolean isSufficient() {
        return StringUtils.isNotBlank((CharSequence)this.getText()) && !this.getRecipients().isEmpty();
    }

    @Generated
    protected SmsRequest(SmsRequestBuilder<?, ?> b) {
        this.principal = b.principal;
        this.attribute = b.attribute;
        this.text = b.text;
        this.from = b.from;
        this.to = b.to;
        this.tenant = b.tenant;
    }

    @Generated
    public static SmsRequestBuilder<?, ?> builder() {
        return new SmsRequestBuilderImpl();
    }

    @Generated
    public Principal getPrincipal() {
        return this.principal;
    }

    @Generated
    public String getAttribute() {
        return this.attribute;
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public String getFrom() {
        return this.from;
    }

    @Generated
    public List<String> getTo() {
        return this.to;
    }

    @Generated
    public String getTenant() {
        return this.tenant;
    }

    @Generated
    public SmsRequest withPrincipal(Principal principal) {
        return this.principal == principal ? this : new SmsRequest(principal, this.attribute, this.text, this.from, this.to, this.tenant);
    }

    @Generated
    public SmsRequest withAttribute(String attribute) {
        return this.attribute == attribute ? this : new SmsRequest(this.principal, attribute, this.text, this.from, this.to, this.tenant);
    }

    @Generated
    public SmsRequest withText(String text) {
        return this.text == text ? this : new SmsRequest(this.principal, this.attribute, text, this.from, this.to, this.tenant);
    }

    @Generated
    public SmsRequest withFrom(String from) {
        return this.from == from ? this : new SmsRequest(this.principal, this.attribute, this.text, from, this.to, this.tenant);
    }

    @Generated
    public SmsRequest withTo(List<String> to) {
        return this.to == to ? this : new SmsRequest(this.principal, this.attribute, this.text, this.from, to, this.tenant);
    }

    @Generated
    public SmsRequest withTenant(String tenant) {
        return this.tenant == tenant ? this : new SmsRequest(this.principal, this.attribute, this.text, this.from, this.to, tenant);
    }

    @Generated
    public SmsRequest(Principal principal, String attribute, String text, String from, List<String> to, String tenant) {
        this.principal = principal;
        this.attribute = attribute;
        this.text = text;
        this.from = from;
        this.to = to;
        this.tenant = tenant;
    }

    @Generated
    public static abstract class SmsRequestBuilder<C extends SmsRequest, B extends SmsRequestBuilder<C, B>> {
        @Generated
        private Principal principal;
        @Generated
        private String attribute;
        @Generated
        private String text;
        @Generated
        private String from;
        @Generated
        private List<String> to;
        @Generated
        private String tenant;

        @Generated
        public B principal(Principal principal) {
            this.principal = principal;
            return this.self();
        }

        @Generated
        public B attribute(String attribute) {
            this.attribute = attribute;
            return this.self();
        }

        @Generated
        public B text(String text) {
            this.text = text;
            return this.self();
        }

        @Generated
        public B from(String from) {
            this.from = from;
            return this.self();
        }

        @Generated
        public B to(List<String> to) {
            this.to = to;
            return this.self();
        }

        @Generated
        public B tenant(String tenant) {
            this.tenant = tenant;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SmsRequest.SmsRequestBuilder(principal=" + String.valueOf(this.principal) + ", attribute=" + this.attribute + ", text=" + this.text + ", from=" + this.from + ", to=" + String.valueOf(this.to) + ", tenant=" + this.tenant + ")";
        }
    }

    @Generated
    private static final class SmsRequestBuilderImpl
    extends SmsRequestBuilder<SmsRequest, SmsRequestBuilderImpl> {
        @Generated
        private SmsRequestBuilderImpl() {
        }

        @Override
        @Generated
        protected SmsRequestBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SmsRequest build() {
            return new SmsRequest(this);
        }
    }
}

