/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.BaseRegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.RegexUtils;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class HttpRequestRegisteredServiceAccessStrategy
extends BaseRegisteredServiceAccessStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestRegisteredServiceAccessStrategy.class);
    private static final long serialVersionUID = -1108201604115278440L;
    private String ipAddress;
    private String userAgent;
    @JsonProperty(value="headers")
    private Map<String, String> headers = new TreeMap<String, String>();

    public boolean isServiceAccessAllowed(RegisteredService registeredService, Service service) {
        return Optional.ofNullable(ClientInfoHolder.getClientInfo()).stream().anyMatch(info -> {
            boolean match = true;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.ipAddress})) {
                LOGGER.debug("Evaluating IP address [{}] against pattern [{}]", (Object)info.getClientIpAddress(), (Object)this.ipAddress);
                match = RegexUtils.find((String)this.ipAddress, (String)info.getClientIpAddress());
            }
            if (match && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.userAgent})) {
                LOGGER.debug("Evaluating user agent [{}] against pattern [{}]", (Object)info.getUserAgent(), (Object)this.userAgent);
                match = RegexUtils.find((String)this.userAgent, (String)info.getUserAgent());
            }
            if (match && !this.headers.isEmpty()) {
                LOGGER.debug("Evaluating request headers [{}] against pattern [{}]", (Object)info.getHeaders(), this.headers);
                match = this.headers.entrySet().stream().filter(header -> info.getHeaders().containsKey(header.getKey())).allMatch(header -> {
                    Serializable headerValue = (Serializable)info.getHeaders().get(header.getKey());
                    return RegexUtils.find((String)((String)header.getValue()), (String)headerValue.toString());
                });
            }
            return match;
        });
    }

    @Override
    @Generated
    public String toString() {
        return "HttpRequestRegisteredServiceAccessStrategy(super=" + super.toString() + ", ipAddress=" + this.ipAddress + ", userAgent=" + this.userAgent + ", headers=" + String.valueOf(this.headers) + ")";
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public String getUserAgent() {
        return this.userAgent;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public HttpRequestRegisteredServiceAccessStrategy setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @Generated
    public HttpRequestRegisteredServiceAccessStrategy setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Generated
    public HttpRequestRegisteredServiceAccessStrategy setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequestRegisteredServiceAccessStrategy)) {
            return false;
        }
        HttpRequestRegisteredServiceAccessStrategy other = (HttpRequestRegisteredServiceAccessStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$ipAddress = this.ipAddress;
        String other$ipAddress = other.ipAddress;
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$userAgent = this.userAgent;
        String other$userAgent = other.userAgent;
        if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
            return false;
        }
        Map<String, String> this$headers = this.headers;
        Map<String, String> other$headers = other.headers;
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpRequestRegisteredServiceAccessStrategy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $ipAddress = this.ipAddress;
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $userAgent = this.userAgent;
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        Map<String, String> $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    @Generated
    public HttpRequestRegisteredServiceAccessStrategy() {
    }
}

