/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.pages;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.SyncopeWebApplication;
import org.apache.syncope.client.enduser.commons.ProvisioningUtils;
import org.apache.syncope.client.enduser.pages.BasePage;
import org.apache.syncope.client.enduser.pages.BaseReauthPage;
import org.apache.syncope.client.enduser.pages.SelfResult;
import org.apache.syncope.client.enduser.panels.captcha.CaptchaPanel;
import org.apache.syncope.client.enduser.rest.SecurityQuestionRestClient;
import org.apache.syncope.client.enduser.rest.UserSelfRestClient;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.client.ui.commons.panels.CardPanel;
import org.apache.syncope.common.lib.request.StringReplacePatchItem;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.SecurityQuestionTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class EditSecurityQuestion
extends BaseReauthPage {
    private static final long serialVersionUID = -537205681762708502L;
    protected static final String EDIT_SECURITY_QUESTION = "page.editSecurityQuestion";
    @SpringBean
    protected SecurityQuestionRestClient securityQuestionRestClient;
    @SpringBean
    protected UserSelfRestClient userSelfRestClient;
    protected final AjaxDropDownChoicePanel<String> securityQuestion;
    protected final FieldPanel<String> securityAnswer;
    protected final UserTO userTO = SyncopeEnduserSession.get().getSelfTO(true);

    public EditSecurityQuestion(PageParameters parameters) {
        super(parameters, EDIT_SECURITY_QUESTION);
        WebMarkupContainer content = new WebMarkupContainer("content");
        content.setOutputMarkupId(true);
        this.contentWrapper.add(new Component[]{content});
        StatelessForm form = new StatelessForm("securityQuestionForm");
        form.setOutputMarkupId(true);
        content.add(new Component[]{form});
        this.securityQuestion = new AjaxDropDownChoicePanel("securityQuestion", "securityQuestion", (IModel)new PropertyModel((Object)this.userTO, "securityQuestion"));
        this.securityQuestion.setNullValid(true);
        this.securityQuestion.setRequired(true);
        final List<SecurityQuestionTO> securityQuestions = this.securityQuestionRestClient.list();
        this.securityQuestion.setChoices(securityQuestions.stream().map(SecurityQuestionTO::getKey).collect(Collectors.toList()));
        this.securityQuestion.setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<String>(this){
            private static final long serialVersionUID = -4421146737845000747L;
            final /* synthetic */ EditSecurityQuestion this$0;
            {
                this.this$0 = this$0;
            }

            public Object getDisplayValue(String value) {
                return securityQuestions.stream().filter(sq -> value.equals(sq.getKey())).map(SecurityQuestionTO::getContent).findFirst().orElse(null);
            }

            public String getIdValue(String value, int index) {
                return value;
            }

            public String getObject(String id, IModel<? extends List<? extends String>> choices) {
                return id;
            }
        });
        this.securityQuestion.add(new Behavior[]{new AjaxEventBehavior("change"){
            private static final long serialVersionUID = 192359260308762078L;

            protected void onEvent(AjaxRequestTarget target) {
                EditSecurityQuestion.this.securityAnswer.setEnabled(StringUtils.isNotBlank((CharSequence)((CharSequence)((Object)EditSecurityQuestion.this.securityQuestion.getModelObject()))));
                target.add(new Component[]{EditSecurityQuestion.this.securityAnswer});
            }
        }});
        form.add(new Component[]{this.securityQuestion});
        this.securityAnswer = new AjaxTextFieldPanel("securityAnswer", "securityAnswer", (IModel)new PropertyModel((Object)this.userTO, "securityAnswer"), false);
        form.add(new Component[]{this.securityAnswer.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true).setEnabled(StringUtils.isNotBlank((CharSequence)((CharSequence)((Object)this.securityQuestion.getModelObject()))))});
        this.securityAnswer.setRequired(true);
        final CaptchaPanel captcha = new CaptchaPanel("contentPanel");
        captcha.setOutputMarkupPlaceholderTag(true);
        form.add(new Component[]{new CardPanel.Builder().setName("captcha").setComponent(captcha).isVisible(SyncopeWebApplication.get().isCaptchaEnabled()).build("captchaPanelCard")});
        AjaxButton submitButton = new AjaxButton(this, "submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){
            private static final long serialVersionUID = 429178684321093953L;
            final /* synthetic */ EditSecurityQuestion this$0;
            {
                this.this$0 = this$0;
                super(id, model);
            }

            protected void onSubmit(AjaxRequestTarget target) {
                if (SyncopeWebApplication.get().isCaptchaEnabled() && !captcha.check()) {
                    SyncopeEnduserSession.get().error((Serializable)((Object)this.getString("captcha_error")));
                    ((BasePage)this.this$0.getPageReference().getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                } else {
                    try {
                        ProvisioningResult<UserTO> provisioningResult = this.this$0.userSelfRestClient.update(this.this$0.userTO.getETagValue(), (UserUR)new UserUR.Builder(this.this$0.userTO.getKey()).securityQuestion((StringReplacePatchItem)((StringReplacePatchItem.Builder)new StringReplacePatchItem.Builder().value((Object)((String)((Object)this.this$0.securityQuestion.getModelObject())))).build()).securityAnswer((StringReplacePatchItem)((StringReplacePatchItem.Builder)new StringReplacePatchItem.Builder().value((Object)((String)((Object)this.this$0.securityAnswer.getModelObject())))).build()).build());
                        this.setResponsePage((IRequestablePage)new SelfResult(provisioningResult, ProvisioningUtils.managePageParams((Component)this.this$0, "securityquestion.change", !SyncopeWebApplication.get().isReportPropagationErrors() || provisioningResult.getPropagationStatuses().stream().allMatch(ps -> ExecStatus.SUCCESS == ps.getStatus()))));
                    }
                    catch (Exception e) {
                        LOG.error("While updating security question for {}", (Object)SyncopeEnduserSession.get().getSelfTO().getUsername(), (Object)e);
                        SyncopeEnduserSession.get().onException(e);
                        ((BasePage)this.this$0.getPageReference().getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                }
            }

            protected void onError(AjaxRequestTarget target) {
                this.this$0.notificationPanel.refresh((IPartialPageRequestHandler)target);
            }
        };
        form.add(new Component[]{submitButton});
        form.setDefaultButton((IFormSubmittingComponent)submitButton);
        Button cancel = new Button("cancel"){
            private static final long serialVersionUID = 3669569969172391336L;

            public void onSubmit() {
                this.setResponsePage(this.getApplication().getHomePage());
            }
        };
        cancel.setOutputMarkupId(true);
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
    }
}

