/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class UnboundIDRootDSE
extends RootDSE {
    @NotNull
    public static final String ATTR_BASELINE_CONFIG_DIGEST = "baselineConfigurationDigest";
    @NotNull
    public static final String ATTR_CONFIG_MODEL_DIGEST = "configurationModelDigest";
    @NotNull
    public static final String ATTR_INSTANCE_NAME = "ds-instance-name";
    @NotNull
    public static final String ATTR_PRIVATE_NAMING_CONTEXTS = "ds-private-naming-contexts";
    @NotNull
    public static final String ATTR_STARTUP_UUID = "startupUUID";
    @NotNull
    public static final String ATTR_SUPPORTED_OTP_DELIVERY_MECHANISM = "ds-supported-otp-delivery-mechanism";
    @NotNull
    private static final String[] REQUEST_ATTRS;
    private static final long serialVersionUID = 2555047334281707615L;

    public UnboundIDRootDSE(@NotNull Entry rootDSEEntry) {
        super(rootDSEEntry);
    }

    @Nullable
    public static UnboundIDRootDSE getRootDSE(@NotNull LDAPInterface connection) throws LDAPException {
        SearchResultEntry rootDSEEntry = connection.getEntry("", REQUEST_ATTRS);
        if (rootDSEEntry == null) {
            return null;
        }
        return new UnboundIDRootDSE(rootDSEEntry);
    }

    @Nullable
    public String getBaselineConfigurationDigest() {
        return this.getAttributeValue(ATTR_BASELINE_CONFIG_DIGEST);
    }

    @Nullable
    public String getConfigurationModelDigest() {
        return this.getAttributeValue(ATTR_CONFIG_MODEL_DIGEST);
    }

    @Nullable
    public String getInstanceName() {
        return this.getAttributeValue(ATTR_INSTANCE_NAME);
    }

    @Nullable
    public String[] getPrivateNamingContexts() {
        return this.getAttributeValues(ATTR_PRIVATE_NAMING_CONTEXTS);
    }

    @Nullable
    public String getStartupUUID() {
        return this.getAttributeValue(ATTR_STARTUP_UUID);
    }

    @Nullable
    public String[] getSupportedOTPDeliveryMechanisms() {
        return this.getAttributeValues(ATTR_SUPPORTED_OTP_DELIVERY_MECHANISM);
    }

    public boolean supportsOTPDeliveryMechanism(@NotNull String mechanismName) {
        return this.hasAttributeValue(ATTR_SUPPORTED_OTP_DELIVERY_MECHANISM, mechanismName);
    }

    static {
        String[] superAttrs = RootDSE.REQUEST_ATTRS;
        REQUEST_ATTRS = new String[superAttrs.length + 6];
        System.arraycopy(superAttrs, 0, REQUEST_ATTRS, 0, superAttrs.length);
        int i = superAttrs.length;
        UnboundIDRootDSE.REQUEST_ATTRS[i++] = ATTR_BASELINE_CONFIG_DIGEST;
        UnboundIDRootDSE.REQUEST_ATTRS[i++] = ATTR_CONFIG_MODEL_DIGEST;
        UnboundIDRootDSE.REQUEST_ATTRS[i++] = ATTR_INSTANCE_NAME;
        UnboundIDRootDSE.REQUEST_ATTRS[i++] = ATTR_PRIVATE_NAMING_CONTEXTS;
        UnboundIDRootDSE.REQUEST_ATTRS[i++] = ATTR_STARTUP_UUID;
        UnboundIDRootDSE.REQUEST_ATTRS[i++] = ATTR_SUPPORTED_OTP_DELIVERY_MECHANISM;
    }
}

