/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.jdbc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.openjpa.lib.util.J2DoPrivHelper;

public class SQLFormatter {
    private boolean multiLine = false;
    private boolean doubleSpace = true;
    private String newline = J2DoPrivHelper.getLineSeparator();
    private int lineLength = 72;
    private String wrapIndent = "        ";
    private String clauseIndent = "    ";
    private static final String[] selectSeparators = new String[]{"FROM ", "WHERE ", "ORDER BY ", "GROUP BY ", "HAVING "};
    private static final String[] insertSeparators = new String[]{"VALUES "};
    private static final String[] updateSeparators = new String[]{"SET ", "WHERE "};
    private static final String[] deleteSeparators = new String[]{"WHERE "};
    private static final String[] createTableSeparators = new String[]{"( "};
    private static final String[] createIndexSeparators = new String[]{"ON ", "( "};

    public void setNewline(String val) {
        this.newline = val;
    }

    public String getNewline() {
        return this.newline;
    }

    public void setLineLength(int val) {
        this.lineLength = val;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setWrapIndent(String val) {
        this.wrapIndent = val;
    }

    public String getWrapIndent() {
        return this.wrapIndent;
    }

    public void setClauseIndent(String val) {
        this.clauseIndent = val;
    }

    public String getClauseIndent() {
        return this.clauseIndent;
    }

    public void setMultiLine(boolean multiLine) {
        this.multiLine = multiLine;
    }

    public boolean getMultiLine() {
        return this.multiLine;
    }

    public void setDoubleSpace(boolean doubleSpace) {
        this.doubleSpace = doubleSpace;
    }

    public boolean getDoubleSpace() {
        return this.doubleSpace;
    }

    public Object prettyPrint(Object sqlObject) {
        if (!this.multiLine) {
            return this.prettyPrintLine(sqlObject);
        }
        StringBuilder sql = new StringBuilder(sqlObject.toString());
        StringBuilder buf = new StringBuilder(sql.length());
        while (sql.length() > 0) {
            String line = null;
            int index = Math.max(sql.toString().indexOf(";\n"), sql.toString().indexOf(";\r"));
            line = index == -1 ? sql.toString() : sql.substring(0, index + 2);
            sql.delete(0, line.length());
            buf.append(this.prettyPrintLine(line));
            for (int i = 0; i < 1 + (this.getDoubleSpace() ? 1 : 0); ++i) {
                buf.append(J2DoPrivHelper.getLineSeparator());
            }
        }
        return buf.toString();
    }

    private Object prettyPrintLine(Object sqlObject) {
        StringBuilder clause;
        String sql = sqlObject.toString().trim();
        String lowerCaseSql = sql.toLowerCase();
        String[] separators = lowerCaseSql.startsWith("select") ? selectSeparators : (lowerCaseSql.startsWith("insert") ? insertSeparators : (lowerCaseSql.startsWith("update") ? updateSeparators : (lowerCaseSql.startsWith("delete") ? deleteSeparators : (lowerCaseSql.startsWith("create table") ? createTableSeparators : (lowerCaseSql.startsWith("create index") ? createIndexSeparators : new String[]{})))));
        int start = 0;
        int end = -1;
        ArrayList<StringBuilder> clauses = new ArrayList<StringBuilder>();
        clauses.add(new StringBuilder());
        for (String separator : separators) {
            end = lowerCaseSql.indexOf(" " + separator.toLowerCase(), start);
            if (end == -1) break;
            clause = (StringBuilder)clauses.get(clauses.size() - 1);
            clause.append(sql.substring(start, end));
            clause = new StringBuilder();
            clauses.add(clause);
            clause.append(this.clauseIndent);
            clause.append(separator);
            start = end + 1 + separator.length();
        }
        clause = (StringBuilder)clauses.get(clauses.size() - 1);
        clause.append(sql.substring(start));
        StringBuilder pp = new StringBuilder(sql.length());
        Iterator iter = clauses.iterator();
        while (iter.hasNext()) {
            pp.append(this.wrapLine(((StringBuilder)iter.next()).toString()));
            if (!iter.hasNext()) continue;
            pp.append(this.newline);
        }
        return pp.toString();
    }

    private String wrapLine(String line) {
        StringBuilder lines = new StringBuilder(line.length());
        for (int i = 0; i < line.length() && (line.charAt(i) == ' ' || line.charAt(i) == '\t'); ++i) {
            lines.append(line.charAt(i));
        }
        StringTokenizer tok = new StringTokenizer(line);
        int length = 0;
        while (tok.hasMoreTokens()) {
            String elem = tok.nextToken();
            if ((length += elem.length()) >= this.lineLength) {
                lines.append(this.newline);
                lines.append(this.wrapIndent);
                lines.append(elem);
                lines.append(' ');
                length = this.wrapIndent.length() + elem.length() + 1;
                continue;
            }
            if (elem.length() >= this.lineLength) {
                lines.append(elem);
                if (tok.hasMoreTokens()) {
                    lines.append(this.newline);
                }
                lines.append(this.wrapIndent);
                length = this.wrapIndent.length();
                continue;
            }
            lines.append(elem);
            lines.append(' ');
            ++length;
        }
        return lines.toString();
    }

    public static void main(String[] args) {
        SQLFormatter formatter = new SQLFormatter();
        for (String arg : args) {
            System.out.println(formatter.prettyPrint(arg));
        }
    }
}

