/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.QualifiedDBIdentifier;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.SchemaFactory;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;

public class DynamicSchemaFactory
extends SchemaGroup
implements SchemaFactory,
Configurable {
    private static final long serialVersionUID = 1L;
    private transient DBDictionary _dict = null;
    private DBIdentifier _schema = DBIdentifier.NULL;

    public void setConfiguration(Configuration conf) {
        JDBCConfiguration jconf = (JDBCConfiguration)conf;
        this._dict = jconf.getDBDictionaryInstance();
        this._schema = DBIdentifier.newSchema(jconf.getSchema());
    }

    public void startConfiguration() {
    }

    public void endConfiguration() {
    }

    @Override
    public SchemaGroup readSchema() {
        return this;
    }

    @Override
    public void storeSchema(SchemaGroup schema) {
    }

    @Override
    public boolean isKnownTable(Table table) {
        return super.findTable(table) != null;
    }

    @Override
    public boolean isKnownTable(String name) {
        return super.findTable(name) != null;
    }

    @Override
    public boolean isKnownTable(QualifiedDBIdentifier path) {
        return super.findTable(path) != null;
    }

    @Override
    public Table findTable(String name) {
        return super.findTable(name);
    }

    public Table findTable(DBIdentifier name) {
        if (name == null) {
            return null;
        }
        QualifiedDBIdentifier path = QualifiedDBIdentifier.getPath(name);
        return this.findTable(path);
    }

    @Override
    public Table findTable(QualifiedDBIdentifier path) {
        if (DBIdentifier.isNull(path)) {
            return null;
        }
        Table table = super.findTable(path);
        if (table != null) {
            return table;
        }
        DBIdentifier schemaName = DBIdentifier.NULL;
        DBIdentifier tableName = path.getUnqualifiedName();
        schemaName = !DBIdentifier.isNull(path.getSchemaName()) ? path.getSchemaName() : this._schema;
        Schema schema = this.getSchema(schemaName);
        if (schema == null) {
            schema = this.addSchema(schemaName);
        }
        if (tableName.getName().length() > this._dict.maxTableNameLength) {
            return schema.addTable(tableName, this._dict.getValidTableName(tableName, this.getSchema(schemaName)));
        }
        return schema.addTable(tableName);
    }

    @Override
    protected Table newTable(DBIdentifier name, Schema schema) {
        return new DynamicTable(name, schema);
    }

    @Override
    protected Column newColumn(DBIdentifier name, Table table) {
        return new DynamicColumn(name, table);
    }

    private class DynamicColumn
    extends Column {
        private static final long serialVersionUID = 1L;

        @Deprecated
        public DynamicColumn(String name, Table table) {
            super(name, table);
        }

        public DynamicColumn(DBIdentifier name, Table table) {
            super(name, table);
        }

        @Override
        public boolean isCompatible(int type, String typeName, int size, int decimals) {
            if (this.getType() != 1111) {
                return super.isCompatible(type, typeName, size, decimals);
            }
            if (type == 12 && size <= 0) {
                size = ((DynamicSchemaFactory)DynamicSchemaFactory.this)._dict.characterColumnSize;
            }
            this.setType(type);
            this.setSize(size);
            if (typeName != null) {
                this.setTypeIdentifier(DBIdentifier.newColumnDefinition(typeName));
            }
            if (decimals != 0) {
                this.setDecimalDigits(decimals);
            }
            return true;
        }
    }

    private class DynamicTable
    extends Table {
        private static final long serialVersionUID = 1L;

        public DynamicTable(String name, Schema schema) {
            super(name, schema);
        }

        public DynamicTable(DBIdentifier name, Schema schema) {
            super(name, schema);
        }

        @Override
        @Deprecated
        public Column getColumn(String name) {
            return this.getColumn(name, null);
        }

        @Override
        public Column getColumn(DBIdentifier name, boolean create) {
            return this.getColumn(name, null, create);
        }

        @Override
        public Column getColumn(DBIdentifier name) {
            return this.getColumn(name, null);
        }

        @Deprecated
        public Column getColumn(String name, DBDictionary dict) {
            if (name == null) {
                return null;
            }
            return this.getColumn(DBIdentifier.newColumn(name), dict);
        }

        public Column getColumn(DBIdentifier name, DBDictionary dict) {
            return this.getColumn(name, dict, true);
        }

        public Column getColumn(DBIdentifier name, DBDictionary dict, boolean create) {
            if (DBIdentifier.isNull(name)) {
                return null;
            }
            Column col = super.getColumn(name);
            if (col != null || !create) {
                return col;
            }
            if (name.getName().length() > ((DynamicSchemaFactory)DynamicSchemaFactory.this)._dict.maxColumnNameLength || DynamicSchemaFactory.this._dict.getInvalidColumnWordSet().contains(DBIdentifier.toUpper(name).getName())) {
                return this.addColumn(name, DynamicSchemaFactory.this._dict.getValidColumnName(name, (Table)this));
            }
            return this.addColumn(name);
        }
    }
}

