/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Base64;
import org.identityconnectors.framework.common.serializer.BinaryObjectDeserializer;
import org.identityconnectors.framework.common.serializer.BinaryObjectSerializer;
import org.identityconnectors.framework.common.serializer.ObjectSerializerFactory;
import org.identityconnectors.framework.common.serializer.XmlObjectSerializer;
import org.xml.sax.InputSource;

public final class SerializerUtil {
    private SerializerUtil() {
    }

    public static byte[] serializeBinaryObject(Object object) {
        ObjectSerializerFactory fact = ObjectSerializerFactory.getInstance();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryObjectSerializer ser = fact.newBinarySerializer(baos);
        ser.writeObject(object);
        ser.close();
        return baos.toByteArray();
    }

    public static Object deserializeBinaryObject(byte[] bytes) {
        ObjectSerializerFactory fact = ObjectSerializerFactory.getInstance();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        BinaryObjectDeserializer des = fact.newBinaryDeserializer(in);
        return des.readObject();
    }

    public static String serializeBase64Object(Object object) {
        return Base64.getEncoder().encodeToString(SerializerUtil.serializeBinaryObject(object));
    }

    public static Object deserializeBase64Object(String encdata) {
        return SerializerUtil.deserializeBinaryObject(Base64.getDecoder().decode(encdata));
    }

    public static String serializeXmlObject(Object object, boolean includeHeader) {
        ObjectSerializerFactory fact = ObjectSerializerFactory.getInstance();
        StringWriter w = new StringWriter();
        XmlObjectSerializer ser = fact.newXmlSerializer(w, includeHeader, false);
        ser.writeObject(object);
        ser.close(true);
        return w.toString();
    }

    public static Object deserializeXmlObject(String str, boolean validate) {
        ObjectSerializerFactory fact = ObjectSerializerFactory.getInstance();
        InputSource source = new InputSource(new StringReader(str));
        ArrayList rv = new ArrayList();
        fact.deserializeXmlStream(source, object -> {
            rv.add(object);
            return false;
        }, validate);
        return rv.isEmpty() ? null : rv.get(0);
    }

    public static Object cloneObject(Object object) {
        byte[] bytes = SerializerUtil.serializeBinaryObject(object);
        return SerializerUtil.deserializeBinaryObject(bytes);
    }
}

