/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.async;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import org.flowable.common.engine.api.async.AsyncTaskExecutor;
import org.flowable.common.engine.api.async.AsyncTaskInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncTaskInvoker
implements AsyncTaskInvoker {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final AsyncTaskExecutor taskExecutor;

    public DefaultAsyncTaskInvoker(AsyncTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public <T> CompletableFuture<T> submit(Callable<T> task) {
        try {
            return this.taskExecutor.submit(task);
        }
        catch (RejectedExecutionException rejected) {
            this.logger.debug("Task {} was rejected. It will be executed on the current thread.", task, (Object)rejected);
            CompletableFuture<T> future = new CompletableFuture<T>();
            try {
                future.complete(task.call());
            }
            catch (Exception exception) {
                future.completeExceptionally(exception);
            }
            return future;
        }
    }
}

