/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import java.util.concurrent.RejectedExecutionException;
import org.flowable.common.engine.api.async.AsyncTaskExecutor;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.async.DefaultAsyncTaskExecutor;
import org.flowable.common.engine.impl.cfg.TransactionPropagation;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.JobInfo;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.asyncexecutor.AbstractAsyncExecutor;
import org.flowable.job.service.impl.asyncexecutor.AsyncJobExecutorConfiguration;
import org.flowable.job.service.impl.asyncexecutor.ResetExpiredJobsRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncJobExecutor
extends AbstractAsyncExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAsyncJobExecutor.class);
    protected Thread asyncJobAcquisitionThread;
    protected Thread timerJobAcquisitionThread;
    protected Thread resetExpiredJobThread;
    protected AsyncTaskExecutor taskExecutor;
    protected boolean shutdownTaskExecutor;

    public DefaultAsyncJobExecutor() {
    }

    public DefaultAsyncJobExecutor(AsyncJobExecutorConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected boolean executeAsyncJob(JobInfo job, Runnable runnable) {
        try {
            this.taskExecutor.execute(runnable);
            return true;
        }
        catch (RejectedExecutionException e) {
            this.sendRejectedEvent(job);
            this.unacquireJobAfterRejection(job);
            return false;
        }
    }

    protected void sendRejectedEvent(JobInfo job) {
        FlowableEventDispatcher eventDispatcher = this.jobServiceConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_REJECTED, job), this.jobServiceConfiguration.getEngineName());
        }
    }

    protected void unacquireJobAfterRejection(final JobInfo job) {
        CommandConfig commandConfig = new CommandConfig(false, TransactionPropagation.REQUIRES_NEW);
        this.jobServiceConfiguration.getCommandExecutor().execute(commandConfig, (Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                DefaultAsyncJobExecutor.this.jobServiceConfiguration.getJobManager().unacquire(job);
                return null;
            }
        });
    }

    @Override
    protected void startAdditionalComponents() {
        if (this.configuration.isUnlockOwnedJobs()) {
            this.unlockOwnedJobs();
        }
        if (!this.isMessageQueueMode) {
            this.initAsyncJobExecutionThreadPool();
            this.startJobAcquisitionThread();
        }
        if (this.configuration.isTimerRunnableNeeded()) {
            this.startTimerAcquisitionThread();
        }
        this.startResetExpiredJobsThread();
    }

    @Override
    protected void shutdownAdditionalComponents() {
        this.stopResetExpiredJobsThread();
        this.stopTimerAcquisitionThread();
        this.stopJobAcquisitionThread();
        this.stopExecutingAsyncJobs();
        if (this.configuration.isUnlockOwnedJobs()) {
            this.unlockOwnedJobs();
        }
    }

    @Override
    protected ResetExpiredJobsRunnable createResetExpiredJobsRunnable(String resetRunnableName) {
        return new ResetExpiredJobsRunnable(resetRunnableName, this, this.jobServiceConfiguration.getJobEntityManager(), this.jobServiceConfiguration.getTimerJobEntityManager(), this.jobServiceConfiguration.getExternalWorkerJobEntityManager());
    }

    protected void initAsyncJobExecutionThreadPool() {
        if (this.taskExecutor == null) {
            DefaultAsyncTaskExecutor defaultAsyncTaskExecutor = new DefaultAsyncTaskExecutor();
            defaultAsyncTaskExecutor.start();
            this.taskExecutor = defaultAsyncTaskExecutor;
            this.shutdownTaskExecutor = true;
        }
    }

    protected void stopExecutingAsyncJobs() {
        if (this.taskExecutor != null && this.shutdownTaskExecutor) {
            this.taskExecutor.shutdown();
            this.taskExecutor = null;
        }
    }

    protected void startJobAcquisitionThread() {
        if (this.configuration.isAsyncJobAcquisitionEnabled()) {
            if (this.asyncJobAcquisitionThread == null) {
                this.asyncJobAcquisitionThread = new Thread(this.asyncJobsDueRunnable);
            }
            this.asyncJobAcquisitionThread.start();
        }
    }

    protected void startTimerAcquisitionThread() {
        if (this.configuration.isTimerJobAcquisitionEnabled()) {
            if (this.timerJobAcquisitionThread == null) {
                this.timerJobAcquisitionThread = new Thread(this.timerJobRunnable);
            }
            this.timerJobAcquisitionThread.start();
        }
    }

    protected void stopJobAcquisitionThread() {
        if (this.asyncJobAcquisitionThread != null) {
            try {
                this.asyncJobAcquisitionThread.join();
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted while waiting for the async job acquisition thread to terminate", (Throwable)e);
            }
            this.asyncJobAcquisitionThread = null;
        }
    }

    protected void stopTimerAcquisitionThread() {
        if (this.timerJobAcquisitionThread != null) {
            try {
                this.timerJobAcquisitionThread.join();
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted while waiting for the timer job acquisition thread to terminate", (Throwable)e);
            }
            this.timerJobAcquisitionThread = null;
        }
    }

    protected void startResetExpiredJobsThread() {
        if (this.configuration.isResetExpiredJobEnabled()) {
            if (this.resetExpiredJobThread == null) {
                this.resetExpiredJobThread = new Thread(this.resetExpiredJobsRunnable);
            }
            this.resetExpiredJobThread.start();
        }
    }

    protected void stopResetExpiredJobsThread() {
        if (this.resetExpiredJobThread != null) {
            try {
                this.resetExpiredJobThread.join();
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted while waiting for the reset expired jobs thread to terminate", (Throwable)e);
            }
            this.resetExpiredJobThread = null;
        }
    }

    public boolean isAsyncJobAcquisitionEnabled() {
        return this.configuration.isAsyncJobAcquisitionEnabled();
    }

    public void setAsyncJobAcquisitionEnabled(boolean isAsyncJobAcquisitionEnabled) {
        this.configuration.setAsyncJobAcquisitionEnabled(isAsyncJobAcquisitionEnabled);
    }

    public boolean isTimerJobAcquisitionEnabled() {
        return this.configuration.isTimerJobAcquisitionEnabled();
    }

    public void setTimerJobAcquisitionEnabled(boolean isTimerJobAcquisitionEnabled) {
        this.configuration.setTimerJobAcquisitionEnabled(isTimerJobAcquisitionEnabled);
    }

    public boolean isResetExpiredJobEnabled() {
        return this.configuration.isResetExpiredJobEnabled();
    }

    public void setResetExpiredJobEnabled(boolean isResetExpiredJobEnabled) {
        this.configuration.setResetExpiredJobEnabled(isResetExpiredJobEnabled);
    }

    public Thread getTimerJobAcquisitionThread() {
        return this.timerJobAcquisitionThread;
    }

    public void setTimerJobAcquisitionThread(Thread timerJobAcquisitionThread) {
        this.timerJobAcquisitionThread = timerJobAcquisitionThread;
    }

    public Thread getAsyncJobAcquisitionThread() {
        return this.asyncJobAcquisitionThread;
    }

    public void setAsyncJobAcquisitionThread(Thread asyncJobAcquisitionThread) {
        this.asyncJobAcquisitionThread = asyncJobAcquisitionThread;
    }

    public Thread getResetExpiredJobThread() {
        return this.resetExpiredJobThread;
    }

    public void setResetExpiredJobThread(Thread resetExpiredJobThread) {
        this.resetExpiredJobThread = resetExpiredJobThread;
    }

    public boolean isUnlockOwnedJobs() {
        return this.configuration.isUnlockOwnedJobs();
    }

    public void setUnlockOwnedJobs(boolean unlockOwnedJobs) {
        this.configuration.setUnlockOwnedJobs(unlockOwnedJobs);
    }

    @Override
    public AsyncTaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    @Override
    public void setTaskExecutor(AsyncTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }
}

