/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.request.GroupCR;
import org.apache.syncope.common.lib.request.GroupUR;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.ProvisionAction;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.service.AnyService;

@Tag(name="Groups")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="groups")
public interface GroupService
extends AnyService<GroupTO> {
    @Override
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Group matching the provided key; if value looks like a UUID then it is interpreted as key, otherwise as a name.", headers={@Header(name="ETag", schema=@Schema(type="string"), description="Opaque identifier for the latest modification made to the entity returned by this endpoint")})})
    public GroupTO read(String var1);

    @Override
    public PagedResult<GroupTO> search(AnyQuery var1);

    @Parameters(value={@Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"})), @Parameter(name="X-Syncope-Null-Priority-Async", in=ParameterIn.HEADER, description="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", allowEmptyValue=true, schema=@Schema(type="boolean", defaultValue="false"))})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Group successfully created enriched with propagation status information, as Entity, or empty if 'Prefer: return-no-content' was specified", content={@Content(schema=@Schema(implementation=ProvisioningResult.class))}, headers={@Header(name="X-Syncope-Key", schema=@Schema(type="string"), description="UUID generated for the group created"), @Header(name="Location", schema=@Schema(type="string"), description="URL of the group created"), @Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")})})
    @POST
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response create(@NotNull GroupCR var1);

    @Parameters(value={@Parameter(name="Prefer", in=ParameterIn.HEADER, description="Allows client to specify a preference for the result to be returned from the server", allowEmptyValue=true, schema=@Schema(defaultValue="return-content", allowableValues={"return-content", "return-no-content"})), @Parameter(name="If-Match", in=ParameterIn.HEADER, description="When the provided ETag value does not match the latest modification date of the entity, an error is reported and the requested operation is not performed.", allowEmptyValue=true, schema=@Schema(type="string")), @Parameter(name="X-Syncope-Null-Priority-Async", in=ParameterIn.HEADER, description="If 'true', instructs the propagation process not to wait for completion when communicating with External Resources with no priority set", allowEmptyValue=true, schema=@Schema(type="boolean", defaultValue="false")), @Parameter(name="key", description="Group's key", in=ParameterIn.PATH, schema=@Schema(type="string"))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Group successfully updated enriched with propagation status information, as Entity", content={@Content(schema=@Schema(implementation=ProvisioningResult.class))}), @ApiResponse(responseCode="204", description="No content if 'Prefer: return-no-content' was specified", headers={@Header(name="Preference-Applied", schema=@Schema(type="string"), description="Allows the server to inform the client about the fact that a specified preference was applied")}), @ApiResponse(responseCode="412", description="The ETag value provided via the 'If-Match' header does not match the latest modification date of the entity")})
    @PATCH
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public Response update(@NotNull GroupUR var1);

    @GET
    @Path(value="own")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<GroupTO> own();

    @POST
    @Path(value="{key}/members/{action}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public ExecTO provisionMembers(@NotNull @PathParam(value="key") String var1, @NotNull @PathParam(value="action") ProvisionAction var2);
}

