/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecoder;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecodeMessage
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DecodeMessage.class);
    @Nonnull
    private final MessageDecoder decoder;

    public DecodeMessage(@Nonnull MessageDecoder messageDecoder) {
        this.decoder = (MessageDecoder)Constraint.isNotNull((Object)messageDecoder, (String)"MessageDecoder cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            this.log.debug("{} Decoding message using message decoder of type {} for this request", (Object)this.getLogPrefix(), (Object)this.decoder.getClass().getName());
            this.decoder.decode();
            MessageContext msgContext = this.decoder.getMessageContext();
            this.log.debug("{} Incoming request decoded into a message of type {}", (Object)this.getLogPrefix(), (Object)msgContext.getMessage().getClass().getName());
            profileRequestContext.setInboundMessageContext(msgContext);
        }
        catch (MessageDecodingException e) {
            this.log.error("{} Unable to decode incoming request", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToDecode");
        }
        finally {
            this.decoder.destroy();
        }
    }
}

