/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl.dynamicmedia;

import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.format.Ratio;
import io.wcm.handler.mediasource.dam.impl.DamContext;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.ImageProfile;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.NamedDimension;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DynamicMediaPath {
    private static final String IMAGE_SERVER_PATH = "/is/image/";
    private static final String CONTENT_SERVER_PATH = "/is/content/";
    public static final String DOWNLOAD_SUFFIX = "?cdh=attachment";

    private DynamicMediaPath() {
    }

    @NotNull
    public static String buildContent(@NotNull DamContext damContext, boolean contentDispositionAttachment) {
        StringBuilder result = new StringBuilder();
        result.append(CONTENT_SERVER_PATH).append(DynamicMediaPath.encodeDynamicMediaObject(damContext));
        if (contentDispositionAttachment) {
            result.append(DOWNLOAD_SUFFIX);
        }
        return result.toString();
    }

    @NotNull
    public static String buildImage(@NotNull DamContext damContext) {
        return IMAGE_SERVER_PATH + DynamicMediaPath.encodeDynamicMediaObject(damContext);
    }

    @NotNull
    public static String buildImage(@NotNull DamContext damContext, long width, long height) {
        return DynamicMediaPath.buildImage(damContext, width, height, null, null);
    }

    @NotNull
    public static String buildImage(@NotNull DamContext damContext, long width, long height, @Nullable CropDimension cropDimension, @Nullable Integer rotation) {
        Optional<NamedDimension> smartCroppingDef;
        Dimension dimension = DynamicMediaPath.calcWidthHeight(damContext, width, height);
        if (cropDimension != null && cropDimension.isAutoCrop() && rotation == null && (smartCroppingDef = DynamicMediaPath.getSmartCropDimension(damContext, width, height)).isPresent()) {
            return IMAGE_SERVER_PATH + DynamicMediaPath.encodeDynamicMediaObject(damContext) + "%3A" + smartCroppingDef.get().getName();
        }
        StringBuilder result = new StringBuilder();
        result.append(IMAGE_SERVER_PATH).append(DynamicMediaPath.encodeDynamicMediaObject(damContext)).append("?");
        if (cropDimension != null) {
            result.append("crop=").append(cropDimension.getCropStringWidthHeight()).append("&");
        }
        if (rotation != null) {
            result.append("rotate=").append(rotation).append("&");
        }
        result.append("wid=").append(dimension.getWidth()).append("&").append("hei=").append(dimension.getHeight()).append("&").append("fit=stretch");
        return result.toString();
    }

    private static Dimension calcWidthHeight(@NotNull DamContext damContext, long width, long height) {
        Dimension sizeLimit = damContext.getDynamicMediaImageSizeLimit();
        if (width > sizeLimit.getWidth()) {
            double ratio = Ratio.get(width, height);
            long newWidth = sizeLimit.getWidth();
            long newHeight = Math.round((double)newWidth / ratio);
            return DynamicMediaPath.calcWidthHeight(damContext, newWidth, newHeight);
        }
        if (height > sizeLimit.getHeight()) {
            double ratio = Ratio.get(width, height);
            long newHeight = sizeLimit.getHeight();
            long newWidth = Math.round((double)newHeight * ratio);
            return new Dimension(newWidth, newHeight);
        }
        return new Dimension(width, height);
    }

    private static Optional<NamedDimension> getSmartCropDimension(@NotNull DamContext damContext, long width, long height) {
        ImageProfile imageProfile = damContext.getImageProfile();
        if (imageProfile != null) {
            return imageProfile.getSmartCropDefinitions().stream().filter(def -> def.getWidth() == width && def.getHeight() == height).findFirst();
        }
        return Optional.empty();
    }

    private static String encodeDynamicMediaObject(@NotNull DamContext damContext) {
        Object[] pathParts = StringUtils.split((String)damContext.getDynamicMediaObject(), (String)"/");
        try {
            for (int i = 0; i < pathParts.length; ++i) {
                pathParts[i] = URLEncoder.encode((String)pathParts[i], StandardCharsets.UTF_8.name());
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Unsupported encoding.", ex);
        }
        return StringUtils.join((Object[])pathParts, (String)"/");
    }
}

