/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bundleresource.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.bundleresource.impl.BundleResourceCache;
import org.apache.sling.bundleresource.impl.BundleResourceProvider;
import org.apache.sling.bundleresource.impl.PathMapping;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

class BundleResourceWebConsolePlugin
extends HttpServlet {
    private static final long serialVersionUID = 566337139719695235L;
    private static final String LABEL = "bundleresources";
    private volatile ServiceRegistration<Servlet> serviceRegistration;
    private volatile ServiceTracker<ResourceProvider, ResourceProvider> providerTracker;
    private final List<BundleResourceProvider> provider = new ArrayList<BundleResourceProvider>();
    private static BundleResourceWebConsolePlugin INSTANCE;

    static void initPlugin(BundleContext context) {
        if (INSTANCE == null) {
            BundleResourceWebConsolePlugin tmp = new BundleResourceWebConsolePlugin();
            tmp.activate(context);
            INSTANCE = tmp;
        }
    }

    static void destroyPlugin() {
        if (INSTANCE != null) {
            try {
                INSTANCE.deactivate();
            }
            finally {
                INSTANCE = null;
            }
        }
    }

    private BundleResourceWebConsolePlugin() {
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        BundleResourceProvider[] brp;
        PrintWriter pw = res.getWriter();
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
        pw.println("<tr class='content'>");
        pw.println("<th colspan='2' class='content container'>Bundle Resource Provider</th>");
        pw.println("</tr>");
        for (BundleResourceProvider bundleResourceProvider : brp = this.provider.toArray(new BundleResourceProvider[this.provider.size()])) {
            BundleResourceCache cache = bundleResourceProvider.getBundleResourceCache();
            PathMapping path = bundleResourceProvider.getMappedPath();
            pw.println("<tr class='content'>");
            pw.println("<td class='content'>");
            pw.println(cache.getBundle().getBundleId());
            pw.println("</td>");
            pw.println("<td class='content'>");
            pw.println(this.getName(cache.getBundle()));
            pw.println("</td>");
            pw.println("</tr>");
            pw.println("<tr class='content'>");
            pw.println("<td class='content'>&nbsp;</td>");
            pw.println("<td class='content'>");
            pw.println("<table>");
            pw.println("<tr>");
            pw.println("<td>Mapping</td>");
            pw.println("<td>");
            pw.print(path.getResourceRoot());
            if (path.getEntryRoot() != null) {
                pw.print(" ==> ");
                pw.print(path.getEntryRoot());
            }
            pw.println("</td>");
            pw.println("</tr>");
            pw.println("<tr>");
            pw.println("<td>Entry Cache</td>");
            pw.printf("<td>Size: %d, Limit: %d</td>%n", cache.getEntryCacheSize(), cache.getEntryCacheMaxSize());
            pw.println("</tr>");
            pw.println("<tr>");
            pw.println("<td>List Cache</td>");
            pw.printf("<td>Size: %d, Limit: %d</td>%n", cache.getListCacheSize(), cache.getListCacheMaxSize());
            pw.println("</tr>");
            pw.println("</table>");
            pw.println("</td>");
            pw.println("</tr>");
        }
        pw.println("</table>");
    }

    public void activate(BundleContext context) {
        this.providerTracker = new ServiceTracker<ResourceProvider, ResourceProvider>(context, ResourceProvider.class.getName(), null){

            public ResourceProvider addingService(ServiceReference<ResourceProvider> reference) {
                ResourceProvider service = null;
                if (reference.getProperty(BundleResourceProvider.PROP_BUNDLE) != null && (service = (ResourceProvider)super.addingService(reference)) instanceof BundleResourceProvider) {
                    BundleResourceWebConsolePlugin.this.provider.add((BundleResourceProvider)service);
                }
                return service;
            }

            public void removedService(ServiceReference<ResourceProvider> reference, ResourceProvider service) {
                if (service instanceof BundleResourceProvider) {
                    BundleResourceWebConsolePlugin.this.provider.remove(service);
                }
                super.removedService(reference, (Object)service);
            }
        };
        this.providerTracker.open();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Web Console Plugin for Bundle Resource Providers");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("felix.webconsole.label", LABEL);
        ((Dictionary)props).put("felix.webconsole.title", "Bundle Resource Provider");
        ((Dictionary)props).put("felix.webconsole.category", "Sling");
        this.serviceRegistration = context.registerService(Servlet.class, (Object)this, props);
    }

    public void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
        if (this.providerTracker != null) {
            this.providerTracker.close();
            this.providerTracker = null;
        }
    }

    private String getName(Bundle bundle) {
        String name = (String)bundle.getHeaders().get("Bundle-Name");
        if (name == null && (name = bundle.getSymbolicName()) == null) {
            name = bundle.getLocation();
        }
        return name;
    }
}

