/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.HashMap;
import java.util.Map;
import javax.measure.IncommensurableException;
import org.apache.sis.pending.geoapi.referencing.MissingMethods;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.internal.ParameterizedTransformBuilder;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.AbstractSingleOperation;
import org.apache.sis.referencing.operation.DefaultProjection;
import org.apache.sis.referencing.operation.MismatchedDatumException;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;

@XmlType(name="ConversionType")
@XmlRootElement(name="Conversion")
public class DefaultConversion
extends AbstractSingleOperation
implements Conversion {
    private static final long serialVersionUID = -2148164324805562793L;

    public DefaultConversion(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, CoordinateReferenceSystem interpolationCRS, OperationMethod method, MathTransform transform) {
        super(properties, sourceCRS, targetCRS, interpolationCRS, method, transform);
        ArgumentChecks.ensureNonNull((String)"sourceCRS", (Object)sourceCRS);
        ArgumentChecks.ensureNonNull((String)"targetCRS", (Object)targetCRS);
    }

    public DefaultConversion(Map<String, ?> properties, OperationMethod method, MathTransform transform, ParameterValueGroup parameters) {
        super(properties, method);
        this.transform = transform;
        if (transform == null && parameters == null) {
            throw new IllegalArgumentException(Resources.forProperties(properties).getString((short)70));
        }
        this.setParameterValues(parameters, null);
        this.checkDimensions(properties);
    }

    DefaultConversion(Conversion definition, CoordinateReferenceSystem source, CoordinateReferenceSystem target, MathTransformFactory factory) throws FactoryException {
        super((SingleOperation)definition);
        int interpDim = CRS.getDimensionOrZero(super.getInterpolationCRS().orElse(null));
        if (this.transform == null) {
            if (this.parameters == null) {
                throw new InvalidGeodeticParameterException(Resources.format((short)70));
            }
            boolean isDerived = target instanceof GeneralDerivedCRS;
            ParameterizedTransformBuilder builder = new ParameterizedTransformBuilder(factory, null);
            builder.setParameters(this.parameters, true);
            builder.setSourceAxes(source);
            builder.setTargetAxes(target.getCoordinateSystem(), isDerived ? null : (Ellipsoid)DatumOrEnsemble.getEllipsoid(target).orElse(null));
            this.transform = builder.create();
            if (builder instanceof MathTransformProvider.Context) {
                ParameterizedTransformBuilder context = builder;
                this.setParameterValues(context.getCompletedParameters(), new HashMap<String, Boolean>(context.getContextualParameters()));
            }
        } else if (this.sourceCRS == null && this.targetCRS == null) {
            ParameterizedTransformBuilder builder = new ParameterizedTransformBuilder(factory, null);
            builder.setSourceAxes(source.getCoordinateSystem(), null);
            builder.setTargetAxes(target.getCoordinateSystem(), null);
            this.transform = builder.swapAndScaleAxes(this.transform);
        } else {
            this.transform = DefaultConversion.swapAndScaleAxes(this.transform, source, this.sourceCRS, interpDim, true, factory);
            this.transform = DefaultConversion.swapAndScaleAxes(this.transform, this.targetCRS, target, interpDim, false, factory);
            interpDim = 0;
        }
        if (interpDim != 0) {
            this.transform = factory.createPassThroughTransform(interpDim, this.transform, 0);
        }
        this.sourceCRS = source;
        this.targetCRS = target;
    }

    protected DefaultConversion(Conversion operation) {
        super((SingleOperation)operation);
    }

    public static DefaultConversion castOrCopy(Conversion object) {
        if (object == null || object instanceof DefaultConversion) {
            return (DefaultConversion)object;
        }
        if (object instanceof Projection) {
            return new DefaultProjection((Projection)object);
        }
        return new DefaultConversion(object);
    }

    public Class<? extends Conversion> getInterface() {
        return Conversion.class;
    }

    public Conversion specialize(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransformFactory factory) throws FactoryException {
        boolean isProjection;
        ArgumentChecks.ensureNonNull((String)"sourceCRS", (Object)sourceCRS);
        ArgumentChecks.ensureNonNull((String)"targetCRS", (Object)targetCRS);
        DefaultConversion.ensureCompatibleDatum("sourceCRS", super.getSourceCRS(), sourceCRS);
        if (!(targetCRS instanceof GeneralDerivedCRS)) {
            DefaultConversion.ensureCompatibleDatum("targetCRS", super.getTargetCRS(), targetCRS);
        } else {
            DefaultConversion.ensureCompatibleDatum("targetCRS", sourceCRS, super.getTargetCRS());
        }
        boolean bl = isProjection = targetCRS instanceof ProjectedCRS && sourceCRS instanceof GeographicCRS;
        if (super.getSourceCRS() == sourceCRS && super.getTargetCRS() == targetCRS && super.getMathTransform() != null && isProjection == this instanceof Projection) {
            return this;
        }
        if (factory == null) {
            factory = DefaultMathTransformFactory.provider();
        }
        if (isProjection) {
            return new DefaultProjection(this, sourceCRS, targetCRS, factory);
        }
        return new DefaultConversion(this, sourceCRS, targetCRS, factory);
    }

    private static void ensureCompatibleDatum(String param, CoordinateReferenceSystem expected, CoordinateReferenceSystem actual) {
        if (expected instanceof SingleCRS && actual instanceof SingleCRS) {
            DefaultDatumEnsemble<?> other;
            SingleCRS crs1 = (SingleCRS)expected;
            SingleCRS crs2 = (SingleCRS)actual;
            DefaultDatumEnsemble<?> datum = crs1.getDatum();
            if (datum != null) {
                other = crs2.getDatum();
            } else {
                datum = MissingMethods.getDatumEnsemble((CoordinateReferenceSystem)crs1);
                other = MissingMethods.getDatumEnsemble((CoordinateReferenceSystem)crs2);
            }
            if (datum != null && other != null && !Utilities.equalsIgnoreMetadata(datum, other)) {
                throw new MismatchedDatumException(Resources.format((short)28, datum.getName(), param));
            }
        }
    }

    private static MathTransform swapAndScaleAxes(MathTransform transform, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, int interpDim, boolean isSource, MathTransformFactory factory) throws FactoryException {
        if (sourceCRS != null && targetCRS != null && sourceCRS != targetCRS) {
            try {
                Matrix m = CoordinateSystems.swapAndScaleAxes(sourceCRS.getCoordinateSystem(), targetCRS.getCoordinateSystem());
                if (!m.isIdentity()) {
                    if (interpDim != 0) {
                        m = Matrices.createPassThrough(interpDim, m, 0);
                    }
                    MathTransform s = factory.createAffineTransform(m);
                    transform = factory.createConcatenatedTransform(isSource ? s : transform, isSource ? transform : s);
                }
            }
            catch (IncommensurableException e) {
                throw new InvalidGeodeticParameterException(Errors.format((short)59, (Object)(isSource ? "sourceCRS" : "targetCRS"), (Object)(isSource ? sourceCRS : targetCRS).getName()), e);
            }
        }
        return transform;
    }

    private DefaultConversion() {
    }
}

