/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.internal.shared;

import java.lang.reflect.Array;
import java.util.Formatter;
import java.util.Locale;
import org.apache.sis.pending.jdk.JDK15;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Classes;

public final class Strings {
    public static final char CONTINUATION_MARK = '\u2503';
    public static final char CONTINUATION_END = '\u2579';
    public static final String CONTINUATION_ITEM = "\u25b6\u00a0";

    private Strings() {
    }

    public static boolean equalsIgnoreCase(String a, String b) {
        return a == b || a != null && a.equalsIgnoreCase(b);
    }

    public static boolean isNullOrEmpty(String text) {
        return text == null || text.isEmpty();
    }

    public static String orEmpty(String text) {
        return text != null ? text : "";
    }

    public static String trimOrNull(String text) {
        if (text != null && !(text = text.trim().strip()).isEmpty()) {
            return text;
        }
        return null;
    }

    public static Boolean parseBoolean(String text) {
        if (text != null) {
            switch (text.toLowerCase(Locale.US)) {
                case "true": 
                case "yes": 
                case "on": 
                case "1": {
                    return Boolean.TRUE;
                }
                case "false": 
                case "no": 
                case "off": 
                case "0": {
                    return Boolean.FALSE;
                }
            }
        }
        return null;
    }

    public static boolean appendUnicodeIdentifier(StringBuilder appendTo, char separator, String text, String accepted, boolean toLowerCase) {
        boolean added = false;
        boolean toUpperCase = false;
        if (text != null) {
            int c;
            for (int i = 0; i < text.length(); i += Character.charCount(c)) {
                boolean isFirst;
                c = text.codePointAt(i);
                boolean bl = isFirst = appendTo.length() == 0;
                if ((!isFirst ? Character.isUnicodeIdentifierPart(c) : Character.isUnicodeIdentifierStart(c)) || accepted.indexOf(c) >= 0) {
                    if (!isFirst && !added && separator != '\u0000') {
                        appendTo.append(separator);
                    }
                    appendTo.appendCodePoint(toLowerCase ? Character.toLowerCase(c) : (toUpperCase ? Character.toUpperCase(c) : c));
                    added = true;
                    toUpperCase = false;
                    continue;
                }
                toUpperCase = true;
            }
        }
        return added;
    }

    public static String toIndexed(String name, int index) {
        return name + "[" + index + "]";
    }

    public static String bracket(String name, Object index) {
        if (index instanceof CharSequence) {
            return name + "[\u201c" + String.valueOf(index) + "\u201d]";
        }
        return name + "[" + String.valueOf(index) + "]";
    }

    public static String bracket(Class<?> type, Object index) {
        return Strings.bracket(Classes.getShortName(type), index);
    }

    public static String range(Class<?> type, Object lower, Object upper) {
        return Classes.getShortName(type) + "[" + String.valueOf(lower) + " \u2026 " + String.valueOf(upper) + "]";
    }

    public static String toUpperCase(String text, Characters.Filter filter, boolean all) {
        int c;
        int length = text.length();
        int i = 0;
        while (true) {
            if (i >= length) {
                return text;
            }
            c = text.codePointAt(i);
            if (!filter.contains(c) || i == 0 | all && Character.toUpperCase(c) != c) break;
            i += Character.charCount(c);
        }
        StringBuilder buffer = new StringBuilder(length).append(text, 0, i);
        while (i < length) {
            c = text.codePointAt(i);
            if (filter.contains(c)) {
                buffer.appendCodePoint(i == 0 | all ? Character.toUpperCase(c) : c);
            }
            i += Character.charCount(c);
        }
        return buffer.toString();
    }

    public static void insertLineInLeftMargin(StringBuilder buffer, String lineSeparator) {
        int c = 9593;
        int i = CharSequences.skipTrailingWhitespaces(buffer, 0, buffer.length());
        while ((i = buffer.lastIndexOf(lineSeparator, i - 1)) >= 0) {
            buffer.insert(i + lineSeparator.length(), (char)c);
            c = 9475;
        }
    }

    public static String singleLine(String delimiter, CharSequence text) {
        if (text != null) {
            CharSequence[] lines = CharSequences.splitOnEOL(text);
            int count = 0;
            for (int i = 0; i < lines.length; ++i) {
                CharSequence line = CharSequences.trimWhitespaces(lines[i]);
                if (JDK15.isEmpty(line)) continue;
                lines[count++] = line;
            }
            switch (count) {
                case 0: {
                    break;
                }
                case 1: {
                    return lines[0].toString();
                }
                default: {
                    return String.join((CharSequence)delimiter, ArraysExt.resize(lines, count));
                }
            }
        }
        return null;
    }

    public static String toString(Class<?> classe, Object ... properties) {
        StringBuilder buffer = new StringBuilder(80).append(Classes.getShortName(classe)).append('[');
        boolean isNext = false;
        for (int i = 0; i < properties.length; ++i) {
            Object name;
            Object value;
            if ((value = properties[++i]) == null) continue;
            if (isNext) {
                buffer.append(", ");
            }
            if ((name = properties[i - 1]) != null) {
                buffer.append(name).append('=');
            }
            Strings.appendWithHeuristic(value, buffer);
            isNext = true;
        }
        return buffer.append(']').toString();
    }

    public static void appendWithHeuristic(Object value, StringBuilder buffer) {
        if (value.getClass().isArray()) {
            int limit = buffer.length() + 80;
            int n = Array.getLength(value);
            if (n != 1) {
                buffer.append('{');
            }
            for (int j = 0; j < n; ++j) {
                int remaining;
                if (j != 0) {
                    buffer.append(", ");
                }
                if (buffer.length() > limit && (remaining = n - j) > 1) {
                    buffer.append(remaining).append(" more\u2026");
                    break;
                }
                buffer.append(Array.get(value, j));
            }
            if (n != 1) {
                buffer.append('}');
            }
        } else {
            boolean isText = value instanceof CharSequence;
            if (isText) {
                buffer.append('\u201c');
            }
            buffer.append(value);
            if (isText) {
                buffer.append('\u201d');
            }
        }
    }

    public static void formatTo(Formatter formatter, int flags, int width, int precision, String value) {
        Object[] args;
        String format;
        boolean isUpperCase;
        boolean bl = isUpperCase = (flags & 2) != 0;
        if (isUpperCase && (width > 0 || precision >= 0)) {
            value = value.toUpperCase(formatter.locale());
            isUpperCase = false;
        }
        int length = value.length();
        if (precision >= 0) {
            int n = 0;
            for (int i = 0; i < length; i += n) {
                if (--precision < 0) {
                    if (n == 0) {
                        value = "";
                        break;
                    }
                    length = (i -= n) + 1;
                    StringBuilder buffer = new StringBuilder(length);
                    value = buffer.append(value, 0, i).append('\u2026').toString();
                    break;
                }
                n = Character.charCount(value.codePointAt(i));
            }
        }
        if (width > length && (width -= value.codePointCount(0, length)) > 0) {
            format = "%s%s";
            args = new Object[]{value, value};
            args[(flags & 1) != 0 ? 1 : 0] = CharSequences.spaces(width);
        } else {
            format = isUpperCase ? "%S" : "%s";
            args = new Object[]{value};
        }
        formatter.format(format, args);
    }
}

