/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public interface CheckedContainer<E> {
    public Class<? extends E> getElementType();

    public Mutability getMutability();

    public static enum Mutability {
        MODIFIABLE,
        REMOVE_ONLY,
        UNMODIFIABLE,
        IMMUTABLE,
        UNKNOWN;

        private static final Set<Class<?>> MUTABLES;

        public static Mutability of(Collection<?> collection) {
            if (collection != null) {
                if (collection instanceof CheckedContainer) {
                    return ((CheckedContainer)((Object)collection)).getMutability();
                }
                if (collection instanceof EnumSet || MUTABLES.contains(collection.getClass())) {
                    return MODIFIABLE;
                }
            }
            return UNKNOWN;
        }

        final boolean isUnmodifiable() {
            return this == UNMODIFIABLE || this == IMMUTABLE;
        }

        static {
            MUTABLES = Set.of(ArrayDeque.class, ArrayList.class, HashSet.class, LinkedHashSet.class);
        }
    }
}

