/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.awt.Point;
import java.awt.image.Raster;
import java.io.Closeable;
import java.io.IOException;
import java.nio.Buffer;
import org.apache.sis.image.DataType;
import org.apache.sis.image.internal.shared.RasterFactory;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.base.TiledGridResource;
import org.apache.sis.storage.geotiff.DataCube;
import org.apache.sis.storage.geotiff.DataSubset;
import org.apache.sis.storage.geotiff.inflater.Inflater;

final class CompressedSubset
extends DataSubset {
    private final int beforeFirstBand;
    private final long afterLastBand;
    private final int[] skipAfterChunks;
    private final int samplesPerChunk;
    private transient Inflater inflater;

    CompressedSubset(DataCube source, TiledGridResource.Subset subset) throws DataStoreException {
        super(source, subset);
        long afterLastBand = this.sourceScanlineStride - (long)this.sourcePixelStride;
        int between = Math.multiplyExact(this.sourcePixelStride, Math.toIntExact(this.getSubsampling(0) - 1L));
        if (this.includedBands != null && this.sourcePixelStride > 1) {
            int[] skips = new int[this.includedBands.length];
            int m = skips.length - 1;
            int b = this.sourcePixelStride;
            for (int i = m; i >= 0; --i) {
                int n = b;
                b = this.includedBands[i];
                skips[i] = n - b - 1;
            }
            this.beforeFirstBand = b;
            afterLastBand += (long)skips[m];
            int n = m;
            skips[n] = skips[n] + (between + this.beforeFirstBand);
            if (m != 0 && CompressedSubset.startsWithZeros(skips, m)) {
                this.samplesPerChunk = this.includedBands.length;
                this.skipAfterChunks = new int[]{skips[m]};
            } else {
                this.samplesPerChunk = 1;
                this.skipAfterChunks = skips;
            }
        } else {
            int[] nArray;
            if (between != 0) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = between;
            } else {
                nArray = null;
            }
            this.skipAfterChunks = nArray;
            this.samplesPerChunk = this.sourcePixelStride;
            this.beforeFirstBand = 0;
        }
        this.afterLastBand = afterLastBand;
        assert (this.targetPixelStride % this.samplesPerChunk == 0) : this.samplesPerChunk;
    }

    private static boolean startsWithZeros(int[] skipAfterChunks, int m) {
        do {
            if (skipAfterChunks[--m] == 0) continue;
            return false;
        } while (m != 0);
        return true;
    }

    private static int pixelCount(long[] lower, long[] upper, long[] subsampling, int i) {
        int n = Math.toIntExact((upper[i] - lower[i] - 1L) / subsampling[i] + 1L);
        assert (n > 0) : n;
        return n;
    }

    @Override
    Raster readSlice(long[] offsets, long[] byteCounts, long[] lower, long[] upper, long[] subsampling, Point location) throws IOException, DataStoreException {
        DataType dataType = this.getDataType();
        int width = CompressedSubset.pixelCount(lower, upper, subsampling, 0);
        int height = CompressedSubset.pixelCount(lower, upper, subsampling, 1);
        int chunksPerRow = width * (this.targetPixelStride / this.samplesPerChunk);
        int betweenRows = Math.toIntExact(subsampling[1] - 1L);
        long head = (long)this.beforeFirstBand + (long)this.sourcePixelStride * lower[0];
        long tail = this.afterLastBand - (long)this.sourcePixelStride * (lower[0] + (long)(width - 1) * subsampling[0]);
        int pixelsPerElement = this.getPixelsPerElement();
        assert (head % (long)pixelsPerElement == 0L) : head;
        if (this.inflater == null) {
            this.inflater = Inflater.create(this.source.listeners(), this.input(), this.source.getCompression(), this.source.getPredictor(), this.sourcePixelStride, Math.toIntExact(this.getTileSize(0)), chunksPerRow, this.samplesPerChunk, this.skipAfterChunks, pixelsPerElement, dataType);
        }
        Inflater inflater = this.inflater;
        int capacity = this.getBankCapacity(pixelsPerElement);
        Buffer[] banks = new Buffer[this.numBanks];
        for (int b = 0; b < this.numBanks; ++b) {
            Buffer bank = RasterFactory.createBuffer((DataType)dataType, (int)capacity);
            inflater.setInputOutput(offsets[b], byteCounts[b], bank);
            long y = lower[1];
            while (--y >= 0L) {
                inflater.skip(this.sourceScanlineStride);
            }
            int y2 = height;
            while (--y2 > 0) {
                inflater.skip(head);
                inflater.uncompressRow();
                inflater.skip(tail);
                int j = betweenRows;
                while (--j >= 0) {
                    inflater.skip(this.sourceScanlineStride);
                }
            }
            inflater.skip(head);
            inflater.uncompressRow();
            this.fillRemainingRows(bank.flip(), b);
            banks[b] = bank;
        }
        return this.createWritableRaster(RasterFactory.wrap((DataType)dataType, (Buffer[])banks), location);
    }

    @Override
    final Closeable createInflater() {
        assert (this.inflater == null);
        return this::releaseInflater;
    }

    private void releaseInflater() throws IOException {
        assert (Thread.holdsLock(this.source.getSynchronizationLock()));
        Inflater c = this.inflater;
        if (c != null) {
            this.inflater = null;
            c.close();
        }
    }
}

