/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.measure.Unit;
import org.apache.sis.measure.Longitude;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Range;
import org.apache.sis.metadata.InvalidMetadataException;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.internal.shared.ReferencingServices;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.apache.sis.pending.geoapi.evolution.Interim;
import org.apache.sis.pending.jdk.JDK23;
import org.apache.sis.temporal.TemporalDate;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.shared.CollectionsExt;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.TransformException;
import org.opengis.temporal.TemporalPrimitive;

public final class Extents
extends Static {
    private GeographicBoundingBox bounds;
    private DefaultGeographicBoundingBox modifiable;
    public static final Extent WORLD;

    private Extents() {
    }

    public static Collection<? extends Extent> fromIdentificationInfo(Metadata metadata) {
        Collection<Object> result = null;
        if (metadata != null) {
            LinkedHashSet union = null;
            for (Identification id : CollectionsExt.nonNull((Collection)metadata.getIdentificationInfo())) {
                Collection extents;
                if (!(id instanceof DataIdentification) || (extents = ((DataIdentification)id).getExtents()) == result || Containers.isNullOrEmpty((Collection)extents)) continue;
                if (result == null) {
                    result = extents;
                    continue;
                }
                if (union == null) {
                    union = new LinkedHashSet(result);
                }
                if (!union.addAll(extents)) continue;
                result = union;
            }
        }
        return result != null ? result : Collections.emptyList();
    }

    public static GeographicBoundingBox getGeographicBoundingBox(Metadata metadata) {
        if (metadata == null) {
            return null;
        }
        Extents m = new Extents();
        try {
            for (Identification id : CollectionsExt.nonNull((Collection)metadata.getIdentificationInfo())) {
                if (!(id instanceof DataIdentification)) continue;
                for (Extent extent : CollectionsExt.nonNull((Collection)((DataIdentification)id).getExtents())) {
                    if (extent == null) continue;
                    m.addHorizontal(extent);
                }
            }
        }
        catch (TransformException e) {
            throw new InvalidMetadataException(Errors.format((short)26), e);
        }
        return m.bounds;
    }

    public static Optional<GeographicBoundingBox> getGeographicBoundingBox(Stream<? extends Extent> extents) {
        Extents m = new Extents();
        extents.forEach(extent -> {
            if (extent != null) {
                try {
                    m.addHorizontal((Extent)extent);
                }
                catch (TransformException e) {
                    throw new InvalidMetadataException(Errors.format((short)26), e);
                }
            }
        });
        return Optional.ofNullable(m.bounds);
    }

    public static GeographicBoundingBox getGeographicBoundingBox(Extent extent) {
        if (extent == null) {
            return null;
        }
        Extents m = new Extents();
        try {
            m.addHorizontal(extent);
        }
        catch (TransformException e) {
            throw new InvalidMetadataException(Errors.format((short)26), e);
        }
        return m.bounds;
    }

    private void addHorizontal(Extent extent) throws TransformException {
        Object item;
        boolean useOnlyGeographicEnvelopes = false;
        ArrayList<Envelope> fallbacks = new ArrayList<Envelope>();
        for (GeographicExtent element : CollectionsExt.nonNull((Collection)extent.getGeographicElements())) {
            if (element instanceof GeographicBoundingBox) {
                item = (GeographicBoundingBox)element;
                if (this.bounds == null) {
                    if (!DefaultGeographicBoundingBox.getInclusion(item.getInclusion())) continue;
                    this.bounds = item;
                    continue;
                }
                if (this.bounds.equals(item)) continue;
                if (this.modifiable == null) {
                    this.modifiable = new DefaultGeographicBoundingBox(this.bounds);
                    this.bounds = this.modifiable;
                }
                this.modifiable.add((GeographicBoundingBox)item);
                continue;
            }
            if (this.bounds != null || !(element instanceof BoundingPolygon) || Boolean.FALSE.equals(element.getInclusion())) continue;
            for (Geometry geometry : CollectionsExt.nonNull((Collection)((BoundingPolygon)extent).getPolygons())) {
                CoordinateReferenceSystem crs;
                Envelope envelope = Interim.getEnvelope(geometry);
                if (envelope == null || (crs = envelope.getCoordinateReferenceSystem()) == null) continue;
                if (crs instanceof GeographicCRS) {
                    if (!useOnlyGeographicEnvelopes) {
                        useOnlyGeographicEnvelopes = true;
                        fallbacks.clear();
                    }
                } else if (useOnlyGeographicEnvelopes) continue;
                fallbacks.add(envelope);
            }
        }
        if (this.bounds == null) {
            for (Envelope envelope : fallbacks) {
                item = new DefaultGeographicBoundingBox();
                ((DefaultGeographicBoundingBox)item).setBounds(envelope);
                if (this.bounds == null) {
                    this.modifiable = item;
                    this.bounds = this.modifiable;
                    continue;
                }
                this.modifiable.add((GeographicBoundingBox)item);
            }
        }
    }

    public static MeasurementRange<Double> getVerticalRange(Extent extent) {
        MeasurementRange range = null;
        VerticalDatumType selectedMethod = null;
        if (extent != null) {
            try {
                for (VerticalExtent element : CollectionsExt.nonNull((Collection)extent.getVerticalElements())) {
                    Double min = element.getMinimumValue();
                    Double max = element.getMaximumValue();
                    VerticalCRS crs = element.getVerticalCRS();
                    VerticalDatumType method = null;
                    Unit unit = null;
                    if (crs != null) {
                        VerticalDatum datum = crs.getDatum();
                        if (datum != null) {
                            method = datum.getVerticalDatumType();
                        }
                        CoordinateSystemAxis axis = crs.getCoordinateSystem().getAxis(0);
                        unit = axis.getUnit();
                        if (axis.getDirection() == AxisDirection.DOWN) {
                            Double tmp = min;
                            min = -max.doubleValue();
                            max = -tmp.doubleValue();
                        }
                    }
                    if (min == null) {
                        min = Double.NEGATIVE_INFINITY;
                    }
                    if (max == null) {
                        max = Double.POSITIVE_INFINITY;
                    }
                    if (range != null) {
                        Unit previous;
                        if (method == null || unit == null) continue;
                        if (method != selectedMethod) {
                            if (selectedMethod == VerticalDatumType.GEOIDAL || method != VerticalDatumType.GEOIDAL && method != VerticalDatumType.DEPTH) {
                                continue;
                            }
                        } else if (selectedMethod != null && (previous = range.unit()) != null) {
                            if (!previous.isCompatible(unit)) continue;
                            range = (MeasurementRange)range.union((Range)MeasurementRange.create((double)min, (boolean)true, (double)max, (boolean)true, (Unit)unit));
                            continue;
                        }
                    }
                    range = MeasurementRange.create((double)min, (boolean)true, (double)max, (boolean)true, (Unit)unit);
                    selectedMethod = method;
                }
            }
            catch (IllegalArgumentException e) {
                throw new InvalidMetadataException(e.toString(), e);
            }
        }
        return range;
    }

    public static Range<Date> getTimeRange(Extent extent) {
        Temporal[] period = Extents.getPeriod(extent);
        Date min = TemporalDate.toDate(period[0]);
        Date max = TemporalDate.toDate(period[1]);
        if (min == null && max == null) {
            return null;
        }
        return new Range(Date.class, (Comparable)min, true, (Comparable)max, true);
    }

    @Deprecated(since="1.5", forRemoval=true)
    public static Date getDate(Extent extent, double location) {
        return TemporalDate.toDate(Extents.getInstant(extent, null, location).orElse(null));
    }

    public static Optional<Instant> getInstant(Extent extent, ZoneId zone, double location) {
        ArgumentChecks.ensureFinite((String)"location", (double)location);
        Temporal[] period = Extents.getPeriod(extent);
        Instant min = TemporalDate.toInstant(period[0], zone);
        Instant max = TemporalDate.toInstant(period[1], zone);
        if (min == null || location == 1.0) {
            return Optional.ofNullable(max);
        }
        if (max != null && location != 0.0) {
            min = min.plusMillis(Math.round(location * (double)JDK23.until((Instant)min, (Instant)max).toMillis()));
        }
        return Optional.of(min);
    }

    private static Temporal[] getPeriod(Extent extent) {
        Temporal min = null;
        Temporal max = null;
        if (extent != null) {
            for (TemporalExtent t : CollectionsExt.nonNull((Collection)extent.getTemporalElements())) {
                Temporal endTime;
                Temporal startTime;
                if (t instanceof DefaultTemporalExtent) {
                    DefaultTemporalExtent dt = (DefaultTemporalExtent)t;
                    startTime = dt.getBeginning().orElse(null);
                    endTime = dt.getEnding().orElse(null);
                } else {
                    TemporalPrimitive p = t.getExtent();
                    startTime = DefaultTemporalExtent.getBound(p, true);
                    endTime = DefaultTemporalExtent.getBound(p, false);
                }
                if (startTime != null && (min == null || TemporalDate.compare(startTime, min) < 0)) {
                    min = startTime;
                }
                if (endTime == null || max != null && TemporalDate.compare(endTime, max) <= 0) continue;
                max = endTime;
            }
        }
        return new Temporal[]{min, max};
    }

    public static String getDescription(Extent extent, Locale locale) {
        return extent != null ? Types.toString(extent.getDescription(), locale) : null;
    }

    public static DirectPosition centroid(GeographicBoundingBox bbox) {
        if (bbox != null) {
            double y = (bbox.getNorthBoundLatitude() + bbox.getSouthBoundLatitude()) / 2.0;
            double x = bbox.getWestBoundLongitude();
            double xmax = bbox.getEastBoundLongitude();
            if (xmax < x) {
                xmax += 360.0;
            }
            if (Double.isFinite(x = Longitude.normalize((double)((x + xmax) / 2.0))) || Double.isFinite(y)) {
                return ReferencingServices.getInstance().geographic(x, y);
            }
        }
        return null;
    }

    public static double area(GeographicBoundingBox box) {
        if (box == null) {
            return Double.NaN;
        }
        double \u0394\u03bb = box.getEastBoundLongitude() - box.getWestBoundLongitude();
        double span = 360.0;
        if (\u0394\u03bb > 360.0) {
            \u0394\u03bb = 360.0;
        } else if (\u0394\u03bb < 0.0) {
            \u0394\u03bb = \u0394\u03bb < -360.0 ? -360.0 : (\u0394\u03bb += 360.0);
        }
        return 4.0589730194049E13 * Math.toRadians(\u0394\u03bb) * Math.max(0.0, Math.sin(Math.toRadians(box.getNorthBoundLatitude())) - Math.sin(Math.toRadians(box.getSouthBoundLatitude())));
    }

    public static GeographicBoundingBox union(GeographicBoundingBox b1, GeographicBoundingBox b2) {
        return Extents.apply(b1, b2, DefaultGeographicBoundingBox::new, DefaultGeographicBoundingBox::add);
    }

    public static GeographicBoundingBox intersection(GeographicBoundingBox b1, GeographicBoundingBox b2) {
        return Extents.apply(b1, b2, DefaultGeographicBoundingBox::new, DefaultGeographicBoundingBox::intersect);
    }

    static GeographicExtent intersection(GeographicExtent e1, GeographicExtent e2) {
        return Extents.intersection(e1 instanceof GeographicBoundingBox ? (GeographicBoundingBox)e1 : null, e2 instanceof GeographicBoundingBox ? (GeographicBoundingBox)e2 : null);
    }

    public static VerticalExtent intersection(VerticalExtent e1, VerticalExtent e2) {
        return Extents.apply(e1, e2, DefaultVerticalExtent::new, DefaultVerticalExtent::intersect);
    }

    public static TemporalExtent intersection(TemporalExtent e1, TemporalExtent e2) {
        return Extents.apply(e1, e2, DefaultTemporalExtent::new, DefaultTemporalExtent::intersect);
    }

    public static Extent intersection(Extent e1, Extent e2) {
        return Extents.apply(e1, e2, DefaultExtent::new, DefaultExtent::intersect);
    }

    private static <I, C extends ISOMetadata> I apply(I e1, I e2, Function<I, C> constructor, BiConsumer<C, I> operator) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null || e2 == e1) {
            return e1;
        }
        ISOMetadata result = (ISOMetadata)constructor.apply(e1);
        operator.accept(result, e2);
        if (result.equals(e1, ComparisonMode.BY_CONTRACT)) {
            return e1;
        }
        if (result.equals(e2, ComparisonMode.BY_CONTRACT)) {
            return e2;
        }
        return (I)result;
    }

    public static boolean isWorld(Extent extent) {
        if (extent != null) {
            for (GeographicExtent element : CollectionsExt.nonNull((Collection)extent.getGeographicElements())) {
                GeographicBoundingBox item;
                if (!(element instanceof GeographicBoundingBox) || !((item = (GeographicBoundingBox)element).getWestBoundLongitude() <= -180.0) || !(item.getEastBoundLongitude() >= 180.0) || !(item.getSouthBoundLatitude() <= -90.0) || !(item.getNorthBoundLatitude() >= 90.0)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        DefaultGeographicBoundingBox box = new DefaultGeographicBoundingBox(-180.0, 180.0, -90.0, 90.0);
        box.transitionTo(ModifiableMetadata.State.FINAL);
        DefaultExtent world = new DefaultExtent((CharSequence)Vocabulary.formatInternational((short)225), box, null, null);
        world.transitionTo(ModifiableMetadata.State.FINAL);
        WORLD = world;
    }
}

