/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema;

import io.protostuff.InputEx;
import io.protostuff.OutputEx;
import io.protostuff.SchemaEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.common.utils.bean.Setter;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyWrapper;
import org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.MessageReadSchema;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.MessageWriteSchema;

public class PropertyWrapperAsFieldSchema<T>
extends FieldSchema<T> {
    private final SchemaEx<Object> schema;
    private final FieldSchema<Object> fieldSchema;
    protected final Getter<T, Object> getter;
    protected final Setter<T, Object> setter;

    public PropertyWrapperAsFieldSchema(Field protoField, PropertyDescriptor propertyDescriptor, SchemaEx<Object> schema) {
        super(protoField, propertyDescriptor.getJavaType());
        this.schema = schema;
        this.getter = (Getter)propertyDescriptor.getGetter();
        this.setter = (Setter)propertyDescriptor.getSetter();
        if (schema instanceof MessageWriteSchema) {
            this.fieldSchema = ((MessageWriteSchema)schema).getMainPojoFieldMaps().getFieldByNumber(1);
            return;
        }
        this.fieldSchema = ((MessageReadSchema)schema).getFieldMap().getFieldByNumber(1);
    }

    @Override
    public void getAndWriteTo(OutputEx output, T message) throws IOException {
        output.writeObject(this.tag, this.tagSize, message, this.fieldSchema::writeTo);
    }

    @Override
    public void writeTo(OutputEx output, Object value) throws IOException {
        output.writeObject(this.tag, this.tagSize, value, this.fieldSchema::writeTo);
    }

    @Override
    public int mergeFrom(InputEx input, T message) throws IOException {
        PropertyWrapper wrapper = new PropertyWrapper();
        input.mergeObject(wrapper, this.schema);
        this.setter.set(message, wrapper.getValue());
        return input.readFieldNumber();
    }
}

