/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.apis;

import com.google.common.base.Preconditions;
import java.time.Duration;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.SessionCredentialsProvider;

public class ClientConfigurationBuilder {
    private String endpoints;
    private SessionCredentialsProvider sessionCredentialsProvider = null;
    private Duration requestTimeout = Duration.ofSeconds(3L);

    public ClientConfigurationBuilder setEndpoints(String endpoints) {
        Preconditions.checkNotNull((Object)endpoints, (Object)"endpoints should not be null");
        this.endpoints = endpoints;
        return this;
    }

    public ClientConfigurationBuilder setCredentialProvider(SessionCredentialsProvider sessionCredentialsProvider) {
        this.sessionCredentialsProvider = (SessionCredentialsProvider)Preconditions.checkNotNull((Object)sessionCredentialsProvider, (Object)"credentialsProvider should not be null");
        return this;
    }

    public ClientConfigurationBuilder setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = (Duration)Preconditions.checkNotNull((Object)requestTimeout, (Object)"requestTimeout should not be null");
        return this;
    }

    public ClientConfiguration build() {
        Preconditions.checkNotNull((Object)this.endpoints, (Object)"endpoints should not be null");
        Preconditions.checkNotNull((Object)this.requestTimeout, (Object)"requestTimeout should not be null");
        return new ClientConfiguration(this.endpoints, this.sessionCredentialsProvider, this.requestTimeout);
    }
}

