/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.SecurityToken;

class CompoundSecurityToken
implements SecurityToken {
    private final Subject _subject;
    private final AtomicReference<CompoundTokenMapReference> _reference = new AtomicReference();

    CompoundSecurityToken(List<AccessControl<?>> accessControls, Subject subject) {
        this._subject = subject;
        CompoundTokenMapReference compoundTokenMapReference = new CompoundTokenMapReference(accessControls);
        this._reference.set(compoundTokenMapReference);
        compoundTokenMapReference.init(subject);
    }

    Map<AccessControl<?>, SecurityToken> getCompoundToken(List<AccessControl<?>> accessControls) {
        CompoundTokenMapReference ref = this._reference.get();
        if (ref.getAccessControlList() != accessControls) {
            CompoundTokenMapReference oldRef = ref;
            ref = new CompoundTokenMapReference(accessControls);
            ref.init(this._subject);
            this._reference.compareAndSet(oldRef, ref);
        }
        return ref.getCompoundTokenMap();
    }

    private static class CompoundTokenMapReference {
        private final List<AccessControl<?>> _accessControlList;
        private final Map<AccessControl<?>, SecurityToken> _compoundTokenMap;

        private CompoundTokenMapReference(List<AccessControl<?>> accessControlList) {
            this._accessControlList = accessControlList;
            this._compoundTokenMap = new ConcurrentHashMap();
        }

        public synchronized void init(Subject subject) {
            if (this._compoundTokenMap.isEmpty()) {
                for (AccessControl<?> accessControl : this._accessControlList) {
                    Object token;
                    if (accessControl == null || (token = accessControl.newToken(subject)) == null) continue;
                    this._compoundTokenMap.put(accessControl, (SecurityToken)token);
                }
            }
        }

        public List<AccessControl<?>> getAccessControlList() {
            return this._accessControlList;
        }

        public Map<AccessControl<?>, SecurityToken> getCompoundTokenMap() {
            return this._compoundTokenMap;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompoundTokenMapReference that = (CompoundTokenMapReference)o;
            return Objects.equals(this._accessControlList, that._accessControlList) && Objects.equals(this._compoundTokenMap, that._compoundTokenMap);
        }

        public int hashCode() {
            return Objects.hash(this._accessControlList, this._compoundTokenMap);
        }
    }
}

