/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v108.debugger.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v108.debugger.model.CallFrameId;
import org.openqa.selenium.devtools.v108.debugger.model.Location;
import org.openqa.selenium.devtools.v108.debugger.model.Scope;
import org.openqa.selenium.devtools.v108.runtime.model.RemoteObject;
import org.openqa.selenium.json.JsonInput;

public class CallFrame {
    private final CallFrameId callFrameId;
    private final String functionName;
    private final Optional<Location> functionLocation;
    private final Location location;
    private final String url;
    private final List<Scope> scopeChain;
    private final RemoteObject _this;
    private final Optional<RemoteObject> returnValue;
    private final Optional<Boolean> canBeRestarted;

    public CallFrame(CallFrameId callFrameId, String functionName, Optional<Location> functionLocation, Location location, String url, List<Scope> scopeChain, RemoteObject _this, Optional<RemoteObject> returnValue, Optional<Boolean> canBeRestarted) {
        this.callFrameId = Objects.requireNonNull(callFrameId, "callFrameId is required");
        this.functionName = Objects.requireNonNull(functionName, "functionName is required");
        this.functionLocation = functionLocation;
        this.location = Objects.requireNonNull(location, "location is required");
        this.url = Objects.requireNonNull(url, "url is required");
        this.scopeChain = Objects.requireNonNull(scopeChain, "scopeChain is required");
        this._this = Objects.requireNonNull(_this, "this is required");
        this.returnValue = returnValue;
        this.canBeRestarted = canBeRestarted;
    }

    public CallFrameId getCallFrameId() {
        return this.callFrameId;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Optional<Location> getFunctionLocation() {
        return this.functionLocation;
    }

    public Location getLocation() {
        return this.location;
    }

    @Deprecated
    public String getUrl() {
        return this.url;
    }

    public List<Scope> getScopeChain() {
        return this.scopeChain;
    }

    public RemoteObject getThis() {
        return this._this;
    }

    public Optional<RemoteObject> getReturnValue() {
        return this.returnValue;
    }

    @Beta
    public Optional<Boolean> getCanBeRestarted() {
        return this.canBeRestarted;
    }

    private static CallFrame fromJson(JsonInput input) {
        CallFrameId callFrameId = null;
        String functionName = null;
        Optional<Location> functionLocation = Optional.empty();
        Location location = null;
        String url = null;
        List scopeChain = null;
        RemoteObject _this = null;
        Optional<RemoteObject> returnValue = Optional.empty();
        Optional<Boolean> canBeRestarted = Optional.empty();
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "callFrameId": {
                    callFrameId = (CallFrameId)input.read(CallFrameId.class);
                    continue block22;
                }
                case "functionName": {
                    functionName = input.nextString();
                    continue block22;
                }
                case "functionLocation": {
                    functionLocation = Optional.ofNullable((Location)input.read(Location.class));
                    continue block22;
                }
                case "location": {
                    location = (Location)input.read(Location.class);
                    continue block22;
                }
                case "url": {
                    url = input.nextString();
                    continue block22;
                }
                case "scopeChain": {
                    scopeChain = (List)input.read(new TypeToken<List<Scope>>(){}.getType());
                    continue block22;
                }
                case "this": {
                    _this = (RemoteObject)input.read(RemoteObject.class);
                    continue block22;
                }
                case "returnValue": {
                    returnValue = Optional.ofNullable((RemoteObject)input.read(RemoteObject.class));
                    continue block22;
                }
                case "canBeRestarted": {
                    canBeRestarted = Optional.ofNullable(input.nextBoolean());
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CallFrame(callFrameId, functionName, functionLocation, location, url, scopeChain, _this, returnValue, canBeRestarted);
    }
}

