/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.slm;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.ParseField;
import org.opensearch.common.xcontent.ConstructingObjectParser;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;

public class SnapshotInvocationRecord
implements ToXContentObject {
    static final ParseField SNAPSHOT_NAME = new ParseField("snapshot_name", new String[0]);
    static final ParseField TIMESTAMP = new ParseField("time", new String[0]);
    static final ParseField DETAILS = new ParseField("details", new String[0]);
    private String snapshotName;
    private long timestamp;
    private String details;
    public static final ConstructingObjectParser<SnapshotInvocationRecord, String> PARSER = new ConstructingObjectParser("snapshot_policy_invocation_record", true, a -> new SnapshotInvocationRecord((String)a[0], (Long)a[1], (String)a[2]));

    public static SnapshotInvocationRecord parse(XContentParser parser, String name) {
        return (SnapshotInvocationRecord)PARSER.apply(parser, (Object)name);
    }

    public SnapshotInvocationRecord(String snapshotName, long timestamp, String details) {
        this.snapshotName = Objects.requireNonNull(snapshotName, "snapshot name must be provided");
        this.timestamp = timestamp;
        this.details = details;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getDetails() {
        return this.details;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SNAPSHOT_NAME.getPreferredName(), this.snapshotName);
        builder.timeField(TIMESTAMP.getPreferredName(), "time_string", this.timestamp);
        if (Objects.nonNull(this.details)) {
            builder.field(DETAILS.getPreferredName(), this.details);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotInvocationRecord that = (SnapshotInvocationRecord)o;
        return this.getTimestamp() == that.getTimestamp() && Objects.equals(this.getSnapshotName(), that.getSnapshotName()) && Objects.equals(this.getDetails(), that.getDetails());
    }

    public int hashCode() {
        return Objects.hash(this.getSnapshotName(), this.getTimestamp(), this.getDetails());
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SNAPSHOT_NAME);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), TIMESTAMP);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), DETAILS);
    }
}

