/*
 * Decompiled with CFR 0.152.
 */
package org.archive.resource.html;

import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.archive.resource.MetaData;
import org.archive.resource.ResourceConstants;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HTMLMetaData
extends MetaData
implements ResourceConstants {
    private static final Logger LOG = Logger.getLogger(HTMLMetaData.class.getName());
    private JSONObject header;

    public HTMLMetaData(MetaData parentMetaData) {
        super(parentMetaData, "HTML-Metadata");
    }

    private JSONObject getHeader() {
        if (this.header == null) {
            this.header = new JSONObject();
            this.putChild("Head", this.header);
        }
        return this.header;
    }

    public void setBaseHref(String href) {
        this.putUnlessNull(this.getHeader(), "Base", href);
    }

    public void setTitle(String title) {
        this.putUnlessNull(this.getHeader(), "Title", title);
    }

    private void putUnlessNull(JSONObject o, String k, String v) {
        if (o != null) {
            try {
                o.put(k, (Object)v);
            }
            catch (JSONException e) {
                LOG.warning(e.getMessage());
            }
        }
    }

    public String[] LtoA(List<String> l) {
        String[] a = new String[l.size()];
        l.toArray(a);
        return a;
    }

    public void addMeta(List<String> l) {
        this.addMeta(this.LtoA(l));
    }

    public void addMeta(String ... a) {
        this.appendObj2(this.getHeader(), "Metas", a);
    }

    public void addLink(List<String> l) {
        this.addLink(this.LtoA(l));
    }

    public void addLink(String ... a) {
        this.appendObj2(this.getHeader(), "Link", a);
    }

    public void addScript(List<String> l) {
        this.addScript(this.LtoA(l));
    }

    public void addScript(String ... a) {
        this.appendObj2(this.getHeader(), "Scripts", a);
    }

    public void addHref(List<String> l) {
        this.addHref(this.LtoA(l));
    }

    public void addHref(String ... a) {
        this.appendObj2(this, "Links", a);
    }

    private void appendObj2(JSONObject o, String arr, String ... a) {
        if (o == null) {
            return;
        }
        JSONObject n = new JSONObject();
        if ((a.length & 1) == 1) {
            throw new IllegalArgumentException();
        }
        try {
            for (int i = 0; i < a.length; i += 2) {
                n.put(a[i], (Object)a[i + 1]);
            }
            JSONArray jarr = o.optJSONArray(arr);
            if (jarr == null) {
                Object ob = o.remove(arr);
                if (ob != null) {
                    LOG.warning("Removed(" + arr + ") containing:" + ob.toString());
                }
                jarr = new JSONArray();
                jarr.put((Object)n);
                o.put(arr, (Object)jarr);
            } else {
                jarr.put((Object)n);
            }
        }
        catch (JSONException e) {
            try {
                System.err.format(Locale.ROOT, "GotErr(%s) JSON(%s)(%s)", e.getMessage(), o.toString(1), a.toString());
            }
            catch (JSONException e1) {
                System.err.println("JSONERRinJSONErr:" + e1.getMessage());
                e1.printStackTrace();
            }
            LOG.warning(e.getMessage());
        }
    }

    public String getJSONString() {
        return this.toString();
    }
}

