/*
 * Decompiled with CFR 0.152.
 */
package org.archive.resource.generic;

import java.io.IOException;
import java.util.Locale;
import org.archive.resource.MetaData;
import org.archive.resource.Resource;
import org.archive.resource.ResourceContainer;
import org.archive.resource.ResourceParseException;
import org.archive.resource.ResourceProducer;
import org.archive.resource.generic.GenericStreamResource;
import org.archive.streamcontext.Stream;

public class GenericResourceProducer
implements ResourceContainer,
ResourceProducer {
    private static long UNLIMITED = -1L;
    private Stream stream;
    private String name;
    private long endOffset;

    public GenericResourceProducer(Stream stream, String name) {
        this(stream, name, UNLIMITED);
    }

    public GenericResourceProducer(Stream stream, String name, long endOffset) {
        this.stream = stream;
        this.name = name;
        this.endOffset = endOffset;
    }

    @Override
    public Resource getNext() throws ResourceParseException, IOException {
        if (this.stream.atEof()) {
            return null;
        }
        if (this.endOffset != UNLIMITED && this.stream.getOffset() > this.endOffset) {
            return null;
        }
        return new GenericStreamResource(new MetaData(), this, this.stream);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isCompressed() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public String getContext() {
        return String.format(Locale.ROOT, "Context(%s)(%d)", this.name, this.stream.getOffset());
    }
}

