/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.DocumentedTypeDTO;
import org.apache.nifi.web.api.entity.NarDetailsEntity;

public class NarComponentTypesResult
extends AbstractWritableResult<NarDetailsEntity> {
    private final NarDetailsEntity detailsEntity;

    public NarComponentTypesResult(ResultType resultType, NarDetailsEntity detailsEntity) {
        super(resultType);
        this.detailsEntity = detailsEntity;
    }

    @Override
    public NarDetailsEntity getResult() {
        return this.detailsEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        Table table = new Table.Builder().column("#", 3, 3, false).column("Type", 20, 100, false).column("Kind", 20, 30, false).build();
        AtomicInteger counter = new AtomicInteger(0);
        this.writeComponentTypes(this.detailsEntity.getProcessorTypes(), "PROCESSOR", table, counter);
        this.writeComponentTypes(this.detailsEntity.getControllerServiceTypes(), "CONTROLLER_SERVICE", table, counter);
        this.writeComponentTypes(this.detailsEntity.getReportingTaskTypes(), "REPORTING_TASK", table, counter);
        this.writeComponentTypes(this.detailsEntity.getParameterProviderTypes(), "PARAMETER_PROVIDER", table, counter);
        this.writeComponentTypes(this.detailsEntity.getFlowRegistryClientTypes(), "FLOW_REGISTRY_CLIENT", table, counter);
        this.writeComponentTypes(this.detailsEntity.getFlowAnalysisRuleTypes(), "FLOW_ANALYSIS_RULE", table, counter);
        if (counter.get() > 0) {
            DynamicTableWriter tableWriter = new DynamicTableWriter();
            tableWriter.write(table, output);
        }
    }

    private void writeComponentTypes(Set<DocumentedTypeDTO> componentTypes, String kind, Table table, AtomicInteger counter) {
        if (componentTypes == null) {
            return;
        }
        ArrayList<DocumentedTypeDTO> sortedTypes = new ArrayList<DocumentedTypeDTO>(componentTypes);
        sortedTypes.sort(Comparator.comparing(DocumentedTypeDTO::getType));
        for (DocumentedTypeDTO documentedType : sortedTypes) {
            table.addRow("" + counter.incrementAndGet(), documentedType.getType(), kind);
        }
    }
}

