/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.access;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;

public class GetAccessToken
extends AbstractNiFiRegistryCommand<StringResult> {
    public GetAccessToken() {
        super("get-access-token", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Authenticates to NiFi Registry with the given username and password and returns an access token for use on future requests as the value of the " + CommandOption.BEARER_TOKEN.getLongName() + " argument";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.USERNAME.createOption());
        this.addOption(CommandOption.PASSWORD.createOption());
    }

    @Override
    public StringResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        String username = this.getRequiredArg(properties, CommandOption.USERNAME);
        String password = this.getRequiredArg(properties, CommandOption.PASSWORD);
        String token = client.getAccessClient().getToken(username, password);
        return new StringResult(token, this.getContext().isInteractive());
    }
}

