/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.resolvers;

import java.util.Arrays;
import lombok.Generated;
import org.flywaydb.core.api.FlywayException;

public enum ProvisionerMode {
    Provision("provision"),
    Reprovision("reprovision"),
    Skip("skip");

    private final String value;

    public static ProvisionerMode fromString(String value) {
        return Arrays.stream(ProvisionerMode.values()).filter(mode -> mode.value.equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new FlywayException("Unknown provisioner mode: " + value));
    }

    public boolean isHigherPriorityThan(ProvisionerMode other) {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> {
                if (other != Reprovision) {
                    yield true;
                }
                yield false;
            }
            case 0 -> {
                if (other == Skip) {
                    yield true;
                }
                yield false;
            }
            case 2 -> false;
        };
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    private ProvisionerMode(String value) {
        this.value = value;
    }
}

