/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.schema.v1;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.minifi.toolkit.schema.ComponentStatusRepositorySchema;
import org.apache.nifi.minifi.toolkit.schema.ConfigSchema;
import org.apache.nifi.minifi.toolkit.schema.ConnectionSchema;
import org.apache.nifi.minifi.toolkit.schema.ContentRepositorySchema;
import org.apache.nifi.minifi.toolkit.schema.CorePropertiesSchema;
import org.apache.nifi.minifi.toolkit.schema.FlowControllerSchema;
import org.apache.nifi.minifi.toolkit.schema.FlowFileRepositorySchema;
import org.apache.nifi.minifi.toolkit.schema.ProcessorSchema;
import org.apache.nifi.minifi.toolkit.schema.ProvenanceReportingSchema;
import org.apache.nifi.minifi.toolkit.schema.ProvenanceRepositorySchema;
import org.apache.nifi.minifi.toolkit.schema.RemoteProcessGroupSchema;
import org.apache.nifi.minifi.toolkit.schema.SecurityPropertiesSchema;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchema;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchemaWithId;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchemaWithIdAndName;
import org.apache.nifi.minifi.toolkit.schema.common.CollectionOverlap;
import org.apache.nifi.minifi.toolkit.schema.common.ConvertableSchema;
import org.apache.nifi.minifi.toolkit.schema.common.StringUtil;
import org.apache.nifi.minifi.toolkit.schema.v1.ConnectionSchemaV1;
import org.apache.nifi.minifi.toolkit.schema.v1.ProcessorSchemaV1;
import org.apache.nifi.minifi.toolkit.schema.v1.RemoteProcessGroupSchemaV1;

public class ConfigSchemaV1
extends BaseSchema
implements ConvertableSchema<ConfigSchema> {
    public static final String REMOTE_PROCESS_GROUPS_KEY_V1 = "Remote Processing Groups";
    public static final String FOUND_THE_FOLLOWING_DUPLICATE_PROCESSOR_NAMES = "Found the following duplicate processor names: ";
    public static final String FOUND_THE_FOLLOWING_DUPLICATE_CONNECTION_NAMES = "Found the following duplicate connection names: ";
    public static final String FOUND_THE_FOLLOWING_DUPLICATE_REMOTE_PROCESSING_GROUP_NAMES = "Found the following duplicate remote processing group names: ";
    public static final String CANNOT_LOOK_UP_PROCESSOR_ID_FROM_PROCESSOR_NAME_DUE_TO_DUPLICATE_PROCESSOR_NAMES = "Cannot look up Processor id from Processor name due to duplicate Processor names: ";
    public static final int CONFIG_VERSION = 1;
    public static final String CONNECTION_WITH_NAME = "Connection with name ";
    public static final String HAS_INVALID_DESTINATION_NAME = " has invalid destination name ";
    public static final String HAS_INVALID_SOURCE_NAME = " has invalid source name ";
    private FlowControllerSchema flowControllerProperties;
    private CorePropertiesSchema coreProperties;
    private FlowFileRepositorySchema flowfileRepositoryProperties;
    private ContentRepositorySchema contentRepositoryProperties;
    private ComponentStatusRepositorySchema componentStatusRepositoryProperties;
    private SecurityPropertiesSchema securityProperties;
    private List<ProcessorSchemaV1> processors;
    private List<ConnectionSchemaV1> connections;
    private List<RemoteProcessGroupSchemaV1> remoteProcessingGroups;
    private ProvenanceReportingSchema provenanceReportingProperties;
    private ProvenanceRepositorySchema provenanceRepositorySchema;

    public ConfigSchemaV1(Map map) {
        this.flowControllerProperties = this.getMapAsType(map, "Flow Controller", FlowControllerSchema.class, ConfigSchema.TOP_LEVEL_NAME, true);
        this.coreProperties = this.getMapAsType(map, "Core Properties", CorePropertiesSchema.class, ConfigSchema.TOP_LEVEL_NAME, false);
        this.flowfileRepositoryProperties = this.getMapAsType(map, "FlowFile Repository", FlowFileRepositorySchema.class, ConfigSchema.TOP_LEVEL_NAME, false);
        this.contentRepositoryProperties = this.getMapAsType(map, "Content Repository", ContentRepositorySchema.class, ConfigSchema.TOP_LEVEL_NAME, false);
        this.provenanceRepositorySchema = this.getMapAsType(map, "Provenance Repository", ProvenanceRepositorySchema.class, ConfigSchema.TOP_LEVEL_NAME, false);
        this.componentStatusRepositoryProperties = this.getMapAsType(map, "Component Status Repository", ComponentStatusRepositorySchema.class, ConfigSchema.TOP_LEVEL_NAME, false);
        this.securityProperties = this.getMapAsType(map, "Security Properties", SecurityPropertiesSchema.class, ConfigSchema.TOP_LEVEL_NAME, false);
        this.processors = this.convertListToType(this.getOptionalKeyAsType(map, "Processors", List.class, ConfigSchema.TOP_LEVEL_NAME, new ArrayList()), "Processors", ProcessorSchemaV1.class, ConfigSchema.TOP_LEVEL_NAME);
        this.remoteProcessingGroups = this.convertListToType(this.getOptionalKeyAsType(map, REMOTE_PROCESS_GROUPS_KEY_V1, List.class, ConfigSchema.TOP_LEVEL_NAME, new ArrayList()), "remote processing group", RemoteProcessGroupSchemaV1.class, REMOTE_PROCESS_GROUPS_KEY_V1);
        this.connections = this.convertListToType(this.getOptionalKeyAsType(map, "Connections", List.class, ConfigSchema.TOP_LEVEL_NAME, new ArrayList()), "Connections", ConnectionSchemaV1.class, ConfigSchema.TOP_LEVEL_NAME);
        this.provenanceReportingProperties = (ProvenanceReportingSchema)this.getMapAsType(map, "Provenance Reporting", ProvenanceReportingSchema.class, ConfigSchema.TOP_LEVEL_NAME, false, false);
        this.addIssuesIfNotNull(this.flowControllerProperties);
        this.addIssuesIfNotNull(this.coreProperties);
        this.addIssuesIfNotNull(this.flowfileRepositoryProperties);
        this.addIssuesIfNotNull(this.contentRepositoryProperties);
        this.addIssuesIfNotNull(this.componentStatusRepositoryProperties);
        this.addIssuesIfNotNull(this.securityProperties);
        this.addIssuesIfNotNull(this.provenanceReportingProperties);
        this.addIssuesIfNotNull(this.provenanceRepositorySchema);
        this.addIssuesIfNotNull(this.processors);
        this.addIssuesIfNotNull(this.connections);
        this.addIssuesIfNotNull(this.remoteProcessingGroups);
        List<String> processorNames = this.processors.stream().map(ProcessorSchemaV1::getName).collect(Collectors.toList());
        ConfigSchemaV1.checkForDuplicates(this::addValidationIssue, FOUND_THE_FOLLOWING_DUPLICATE_PROCESSOR_NAMES, processorNames);
        ConfigSchemaV1.checkForDuplicates(this::addValidationIssue, FOUND_THE_FOLLOWING_DUPLICATE_CONNECTION_NAMES, this.connections.stream().map(ConnectionSchemaV1::getName).collect(Collectors.toList()));
        ConfigSchemaV1.checkForDuplicates(this::addValidationIssue, FOUND_THE_FOLLOWING_DUPLICATE_REMOTE_PROCESSING_GROUP_NAMES, this.remoteProcessingGroups.stream().map(RemoteProcessGroupSchemaV1::getName).collect(Collectors.toList()));
        HashSet<String> connectableNames = new HashSet<String>(processorNames);
        connectableNames.addAll(this.remoteProcessingGroups.stream().flatMap(r -> r.getInputPorts().stream()).map(BaseSchemaWithId::getId).collect(Collectors.toList()));
        this.connections.forEach(c -> {
            String sourceName;
            String destinationName = c.getDestinationName();
            if (!StringUtil.isNullOrEmpty(destinationName) && !connectableNames.contains(destinationName)) {
                this.addValidationIssue(CONNECTION_WITH_NAME + c.getName() + HAS_INVALID_DESTINATION_NAME + destinationName);
            }
            if (!StringUtil.isNullOrEmpty(sourceName = c.getSourceName()) && !connectableNames.contains(sourceName)) {
                this.addValidationIssue(CONNECTION_WITH_NAME + c.getName() + HAS_INVALID_SOURCE_NAME + sourceName);
            }
        });
    }

    protected List<ProcessorSchema> getProcessorSchemas() {
        HashSet<UUID> ids = new HashSet<UUID>();
        ArrayList<ProcessorSchema> processorSchemas = new ArrayList<ProcessorSchema>(this.processors.size());
        for (ProcessorSchemaV1 processor : this.processors) {
            ProcessorSchema processorSchema = processor.convert();
            processorSchema.setId(ConfigSchemaV1.getUniqueId(ids, processorSchema.getName()));
            processorSchemas.add(processorSchema);
        }
        return processorSchemas;
    }

    protected List<ConnectionSchema> getConnectionSchemas(List<ProcessorSchema> processors, List<String> validationIssues) {
        HashSet<UUID> ids = new HashSet<UUID>();
        HashMap processorNameToIdMap = new HashMap();
        Set<Object> duplicateProcessorNames = new HashSet();
        if (processors != null) {
            processors.stream().forEachOrdered(p -> processorNameToIdMap.put(p.getName(), p.getId()));
            duplicateProcessorNames = new CollectionOverlap(new Stream[]{processors.stream().map(BaseSchemaWithIdAndName::getName)}).getDuplicates();
        }
        HashSet remoteInputPortIds = new HashSet();
        if (this.remoteProcessingGroups != null) {
            remoteInputPortIds.addAll(this.remoteProcessingGroups.stream().filter(r -> r.getInputPorts() != null).flatMap(r -> r.getInputPorts().stream()).map(BaseSchemaWithId::getId).collect(Collectors.toSet()));
        }
        HashSet<String> problematicDuplicateNames = new HashSet<String>();
        ArrayList<ConnectionSchema> connectionSchemas = new ArrayList<ConnectionSchema>(this.connections.size());
        for (ConnectionSchemaV1 connection : this.connections) {
            ConnectionSchema convert = connection.convert();
            convert.setId(ConfigSchemaV1.getUniqueId(ids, convert.getName()));
            String sourceName = connection.getSourceName();
            if (remoteInputPortIds.contains(sourceName)) {
                convert.setSourceId(sourceName);
            } else {
                String sourceId;
                if (duplicateProcessorNames.contains(sourceName)) {
                    problematicDuplicateNames.add(sourceName);
                }
                if (!StringUtil.isNullOrEmpty(sourceId = (String)processorNameToIdMap.get(sourceName))) {
                    convert.setSourceId(sourceId);
                }
            }
            String destinationName = connection.getDestinationName();
            if (remoteInputPortIds.contains(destinationName)) {
                convert.setDestinationId(destinationName);
            } else {
                String destinationId;
                if (duplicateProcessorNames.contains(destinationName)) {
                    problematicDuplicateNames.add(destinationName);
                }
                if (!StringUtil.isNullOrEmpty(destinationId = (String)processorNameToIdMap.get(destinationName))) {
                    convert.setDestinationId(destinationId);
                }
            }
            connectionSchemas.add(convert);
        }
        if (!problematicDuplicateNames.isEmpty()) {
            validationIssues.add(CANNOT_LOOK_UP_PROCESSOR_ID_FROM_PROCESSOR_NAME_DUE_TO_DUPLICATE_PROCESSOR_NAMES + problematicDuplicateNames.stream().collect(Collectors.joining(", ")));
        }
        return connectionSchemas;
    }

    protected List<RemoteProcessGroupSchema> getRemoteProcessGroupSchemas() {
        HashSet<UUID> ids = new HashSet<UUID>();
        ArrayList<RemoteProcessGroupSchema> rpgSchemas = new ArrayList<RemoteProcessGroupSchema>(this.remoteProcessingGroups.size());
        for (RemoteProcessGroupSchemaV1 rpg : this.remoteProcessingGroups) {
            RemoteProcessGroupSchema rpgSchema = rpg.convert();
            rpgSchema.setId(ConfigSchemaV1.getUniqueId(ids, rpgSchema.getName()));
            rpgSchemas.add(rpgSchema);
        }
        return rpgSchemas;
    }

    @Override
    public ConfigSchema convert() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("MiNiFi Config Version", this.getVersion());
        ConfigSchemaV1.putIfNotNull(map, "Flow Controller", this.flowControllerProperties);
        ConfigSchemaV1.putIfNotNull(map, "Core Properties", this.coreProperties);
        ConfigSchemaV1.putIfNotNull(map, "FlowFile Repository", this.flowfileRepositoryProperties);
        ConfigSchemaV1.putIfNotNull(map, "Content Repository", this.contentRepositoryProperties);
        ConfigSchemaV1.putIfNotNull(map, "Provenance Repository", this.provenanceRepositorySchema);
        ConfigSchemaV1.putIfNotNull(map, "Component Status Repository", this.componentStatusRepositoryProperties);
        ConfigSchemaV1.putIfNotNull(map, "Security Properties", this.securityProperties);
        List<ProcessorSchema> processorSchemas = this.getProcessorSchemas();
        ConfigSchemaV1.putListIfNotNull(map, "Processors", processorSchemas);
        List<String> validationIssues = this.getValidationIssues();
        ConfigSchemaV1.putListIfNotNull(map, "Connections", this.getConnectionSchemas(processorSchemas, validationIssues));
        ConfigSchemaV1.putListIfNotNull(map, "Remote Process Groups", this.getRemoteProcessGroupSchemas());
        ConfigSchemaV1.putIfNotNull(map, "Provenance Reporting", this.provenanceReportingProperties);
        return new ConfigSchema(map, validationIssues);
    }

    public static String getUniqueId(Set<UUID> ids, String name) {
        UUID id = UUID.nameUUIDFromBytes(name == null ? "empty_name".getBytes(StandardCharsets.UTF_8) : name.getBytes(StandardCharsets.UTF_8));
        while (ids.contains(id)) {
            id = new UUID(id.getMostSignificantBits(), id.getLeastSignificantBits() + 1L);
        }
        ids.add(id);
        return id.toString();
    }

    @Override
    public int getVersion() {
        return 1;
    }
}

