/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.client;

import java.util.concurrent.TimeUnit;
import org.apache.nifi.remote.client.SiteInfoProvider;
import org.apache.nifi.remote.client.SiteToSiteClient;
import org.apache.nifi.remote.client.SiteToSiteClientConfig;

public abstract class AbstractSiteToSiteClient
implements SiteToSiteClient {
    protected final SiteToSiteClientConfig config;
    protected final SiteInfoProvider siteInfoProvider;

    public AbstractSiteToSiteClient(SiteToSiteClientConfig config) {
        this.config = config;
        int commsTimeout = (int)config.getTimeout(TimeUnit.MILLISECONDS);
        this.siteInfoProvider = new SiteInfoProvider();
        this.siteInfoProvider.setClusterUrls(config.getUrls());
        this.siteInfoProvider.setSslContext(config.getSslContext());
        this.siteInfoProvider.setConnectTimeoutMillis(commsTimeout);
        this.siteInfoProvider.setReadTimeoutMillis(commsTimeout);
        this.siteInfoProvider.setCachedContentsExpirationMillis(config.getCacheExpiration(TimeUnit.MILLISECONDS));
        this.siteInfoProvider.setProxy(config.getHttpProxy());
        this.siteInfoProvider.setLocalAddress(config.getLocalAddress());
    }

    @Override
    public SiteToSiteClientConfig getConfig() {
        return this.config;
    }
}

