/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.nifi.remote.PeerDescription;
import org.apache.nifi.remote.PeerStatus;
import org.apache.nifi.remote.client.PeerPersistence;
import org.apache.nifi.remote.protocol.SiteToSiteTransportProtocol;
import org.apache.nifi.remote.util.PeerStatusCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPeerPersistence
implements PeerPersistence {
    static final String REMOTE_INSTANCE_URIS_PREFIX = "Remote Instance URIs: ";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    protected PeerStatusCache restorePeerStatuses(BufferedReader reader, long cachedTimestamp) throws IOException {
        SiteToSiteTransportProtocol transportProtocol;
        try {
            transportProtocol = SiteToSiteTransportProtocol.valueOf(reader.readLine());
        }
        catch (IllegalArgumentException e) {
            this.logger.info("Discard stored peer statuses in {} because transport protocol is not stored", (Object)this.getClass().getSimpleName());
            return null;
        }
        String line = reader.readLine();
        if (line == null || !line.startsWith(REMOTE_INSTANCE_URIS_PREFIX)) {
            this.logger.info("Discard stored peer statuses in {} because remote instance URIs are not stored", (Object)this.getClass().getSimpleName());
            return null;
        }
        String remoteInstanceUris = line.substring(REMOTE_INSTANCE_URIS_PREFIX.length());
        Set<PeerStatus> restoredStatuses = this.readPeerStatuses(reader);
        if (!restoredStatuses.isEmpty()) {
            this.logger.info("Restored peer statuses from {} {}", (Object)this.getClass().getSimpleName(), restoredStatuses);
            return new PeerStatusCache(restoredStatuses, cachedTimestamp, remoteInstanceUris, transportProtocol);
        }
        return null;
    }

    private Set<PeerStatus> readPeerStatuses(BufferedReader reader) throws IOException {
        String line;
        HashSet<PeerStatus> statuses = new HashSet<PeerStatus>();
        while ((line = reader.readLine()) != null) {
            String[] splits = line.split(Pattern.quote(":"));
            if (splits.length != 3 && splits.length != 4) continue;
            String hostname = splits[0];
            int port = Integer.parseInt(splits[1]);
            boolean secure = Boolean.parseBoolean(splits[2]);
            boolean supportQueryForPeer = splits.length == 4 && Boolean.parseBoolean(splits[3]);
            statuses.add(new PeerStatus(new PeerDescription(hostname, port, secure), 1, supportQueryForPeer));
        }
        return statuses;
    }

    protected void write(PeerStatusCache peerStatusCache, IOConsumer<String> consumer) throws IOException {
        consumer.accept(peerStatusCache.getTransportProtocol().name() + "\n");
        consumer.accept(REMOTE_INSTANCE_URIS_PREFIX + peerStatusCache.getRemoteInstanceUris() + "\n");
        for (PeerStatus status : peerStatusCache.getStatuses()) {
            PeerDescription description = status.getPeerDescription();
            String line = description.getHostname() + ":" + description.getPort() + ":" + description.isSecure() + ":" + status.isQueryForPeers() + "\n";
            consumer.accept(line);
        }
    }

    @FunctionalInterface
    protected static interface IOConsumer<T> {
        public void accept(T var1) throws IOException;
    }
}

