/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.options.Bundle;
import org.netbeans.modules.options.CategoryModel;
import org.netbeans.modules.options.OptionsPanel;
import org.netbeans.modules.options.classic.OptionsAction;
import org.netbeans.modules.options.export.OptionsChooserPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class OptionsDisplayerImpl {
    private static Dialog dialog;
    private static WeakReference<DialogDescriptor> descriptorRef;
    private static String title;
    private static Logger log;
    private FileChangeListener fcl;
    private boolean modal;
    static final LookupListener lookupListener;
    private JButton bOK;
    private JButton bAPPLY;
    private JButton bClassic;
    private JButton btnExport;
    private JButton btnImport;
    private static final RequestProcessor RP;
    private static final int DELAY = 500;
    private boolean savingInProgress = false;
    private FileObject configFile;

    public OptionsDisplayerImpl(boolean modal) {
        this.modal = modal;
        this.fcl = new DefaultFSListener();
        try {
            FileUtil.getConfigRoot().getFileSystem().addFileChangeListener(this.fcl);
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace(ex);
        }
    }

    public void setIsModal(boolean isModal) {
        this.modal = isModal;
    }

    public boolean isOpen() {
        return dialog != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void selectCategory(String path) {
        DialogDescriptor descriptor = null;
        LookupListener lookupListener = OptionsDisplayerImpl.lookupListener;
        synchronized (lookupListener) {
            descriptor = (DialogDescriptor)descriptorRef.get();
        }
        if (descriptor != null) {
            OptionsPanel optionsPanel = (OptionsPanel)descriptor.getMessage();
            String categoryId = path.indexOf(47) == -1 ? path : path.substring(0, path.indexOf(47));
            String subpath = path.indexOf(47) == -1 ? null : path.substring(path.indexOf(47) + 1);
            optionsPanel.initCurrentCategory(categoryId, subpath);
        }
        dialog.toFront();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showOptionsDialog(String categoryID, String subpath, CategoryModel categoryInstance) {
        log.fine("showOptionsDialog(" + categoryID + ", " + subpath + ")");
        if (this.isOpen()) {
            dialog.setVisible(true);
            dialog.toFront();
            log.fine("Front Options Dialog");
            return;
        }
        DialogDescriptor descriptor = null;
        LookupListener lookupListener = OptionsDisplayerImpl.lookupListener;
        synchronized (lookupListener) {
            descriptor = (DialogDescriptor)descriptorRef.get();
        }
        OptionsPanel optionsPanel = null;
        if (descriptor == null) {
            optionsPanel = categoryID == null ? new OptionsPanel(categoryInstance) : new OptionsPanel(categoryID, categoryInstance);
            this.bOK = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_OK");
            this.bOK.getAccessibleContext().setAccessibleDescription(OptionsDisplayerImpl.loc("ACS_OKButton"));
            this.bAPPLY = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_APPLY");
            this.bAPPLY.getAccessibleContext().setAccessibleDescription(OptionsDisplayerImpl.loc("ACS_APPLYButton"));
            this.bAPPLY.setEnabled(false);
            this.bClassic = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_Classic");
            this.bClassic.getAccessibleContext().setAccessibleDescription(OptionsDisplayerImpl.loc("ACS_ClassicButton"));
            this.btnExport = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_Export");
            this.btnExport.getAccessibleContext().setAccessibleDescription(OptionsDisplayerImpl.loc("ACS_Export"));
            this.btnImport = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_Import");
            this.btnImport.getAccessibleContext().setAccessibleDescription(OptionsDisplayerImpl.loc("ACS_Import"));
            this.updateButtons();
            boolean isMac = Utilities.isMac();
            Object[] options = new Object[]{isMac ? DialogDescriptor.CANCEL_OPTION : this.bOK, this.bAPPLY, isMac ? this.bOK : DialogDescriptor.CANCEL_OPTION};
            descriptor = new DialogDescriptor(optionsPanel, title, this.modal, options, DialogDescriptor.OK_OPTION, 0, null, null, false);
            JPanel additionalOptionspanel = new JPanel(new FlowLayout(1, 5, 0));
            additionalOptionspanel.setBorder(new EmptyBorder(0, 0, 0, 0));
            additionalOptionspanel.add(this.bClassic);
            additionalOptionspanel.add(this.btnExport);
            additionalOptionspanel.add(this.btnImport);
            this.setUpButtonListeners(optionsPanel);
            descriptor.setAdditionalOptions(new Object[]{additionalOptionspanel});
            descriptor.setHelpCtx(optionsPanel.getHelpCtx());
            OptionsPanelListener listener = new OptionsPanelListener(descriptor, optionsPanel, this.bOK, this.bAPPLY);
            descriptor.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION, this.bOK});
            descriptor.setButtonListener(listener);
            optionsPanel.addPropertyChangeListener(listener);
            LookupListener lookupListener2 = OptionsDisplayerImpl.lookupListener;
            synchronized (lookupListener2) {
                descriptorRef = new WeakReference<DialogDescriptor>(descriptor);
            }
            log.fine("Create new Options Dialog");
        } else {
            optionsPanel = (OptionsPanel)descriptor.getMessage();
            optionsPanel.setCategoryInstance(categoryInstance);
            optionsPanel.update();
            log.fine("Reopen Options Dialog");
        }
        Dialog tmpDialog = DialogDisplayer.getDefault().createDialog(descriptor, WindowManager.getDefault().getMainWindow());
        log.fine("Options Dialog created; descriptor.title = " + descriptor.getTitle() + "; descriptor.message = " + descriptor.getMessage());
        optionsPanel.initCurrentCategory(categoryID, subpath);
        tmpDialog.addWindowListener(new MyWindowListener(optionsPanel, tmpDialog));
        Point userLocation = this.getUserLocation(optionsPanel);
        if (userLocation != null) {
            tmpDialog.setLocation(userLocation);
            log.fine("userLocation is set to " + userLocation);
        }
        log.fine("setting Options Dialog visible");
        tmpDialog.setVisible(true);
        dialog = tmpDialog;
        this.setUpApplyChecker(optionsPanel);
    }

    private void setUpApplyChecker(final OptionsPanel optsPanel) {
        final RequestProcessor.Task applyChecker = RP.post(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!OptionsDisplayerImpl.this.savingInProgress) {
                            OptionsDisplayerImpl.this.bAPPLY.setEnabled(optsPanel.isChanged() && optsPanel.dataValid());
                        }
                    }
                });
            }
        });
        applyChecker.addTaskListener(new TaskListener(){

            @Override
            public void taskFinished(Task task) {
                if (dialog != null) {
                    applyChecker.schedule(500);
                }
            }
        });
    }

    private void setUpButtonListeners(OptionsPanel optionsPanel) {
        this.btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsChooserPanel.showExportDialog();
            }
        });
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsChooserPanel.showImportDialog();
            }
        });
        final OptionsPanel finalOptionsPanel = optionsPanel;
        this.bClassic.addActionListener(new ActionListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                log.fine("Options Dialog - Classic pressed.");
                Dialog d = dialog;
                dialog = null;
                if (finalOptionsPanel.isChanged()) {
                    NotifyDescriptor.Confirmation confirmationDescriptor = new NotifyDescriptor.Confirmation((Object)OptionsDisplayerImpl.loc("CTL_Some_values_changed"), 1, 3);
                    Object result = DialogDisplayer.getDefault().notify(confirmationDescriptor);
                    if (result == NotifyDescriptor.YES_OPTION) {
                        finalOptionsPanel.save();
                        d.dispose();
                    } else {
                        if (result != NotifyDescriptor.NO_OPTION) {
                            dialog = d;
                            return;
                        }
                        finalOptionsPanel.cancel();
                        d.dispose();
                    }
                } else {
                    d.dispose();
                    finalOptionsPanel.cancel();
                }
                try {
                    CallableSystemAction a = SystemAction.get(OptionsAction.class);
                    a.putValue("additionalActionName", OptionsDisplayerImpl.loc("CTL_Modern"));
                    a.putValue("optionsDialogTitle", OptionsDisplayerImpl.loc("CTL_Classic_Title"));
                    a.putValue("additionalActionListener", new OpenOptionsListener());
                    a.performAction();
                    return;
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace(ex);
                }
            }
        });
    }

    private void updateButtons() {
        if (this.bClassic != null) {
            this.bClassic.setVisible(this.advancedOptionsNotEmpty());
        }
        boolean optionsExportNotEmpty = this.optionsExportNotEmpty();
        if (this.btnExport != null) {
            this.btnExport.setVisible(optionsExportNotEmpty);
        }
        if (this.btnImport != null) {
            this.btnImport.setVisible(optionsExportNotEmpty);
        }
    }

    private boolean advancedOptionsNotEmpty() {
        FileObject servicesFO = this.doGetConfigFile("UI/Services");
        if (servicesFO != null) {
            FileObject[] advancedOptions;
            for (FileObject advancedOption : advancedOptions = servicesFO.getChildren()) {
                Object hidden = advancedOption.getAttribute("hidden");
                if (hidden != null && ((Boolean)hidden).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean optionsExportNotEmpty() {
        FileObject optionsExportFO = this.doGetConfigFile("OptionsExport");
        if (optionsExportFO != null) {
            FileObject[] categories;
            for (FileObject category : categories = optionsExportFO.getChildren()) {
                FileObject[] items;
                Object hiddenCategory = category.getAttribute("hidden");
                if (hiddenCategory != null && ((Boolean)hiddenCategory).booleanValue()) continue;
                for (FileObject item : items = category.getChildren()) {
                    Object hiddenItem = item.getAttribute("hidden");
                    if (hiddenItem != null && ((Boolean)hiddenItem).booleanValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private FileObject doGetConfigFile(final String path) {
        this.configFile = null;
        AtomicBoolean getConfigFileCancelled = new AtomicBoolean(false);
        BaseProgressUtils.runOffEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                OptionsDisplayerImpl.this.configFile = FileUtil.getConfigFile(path);
            }
        }, Bundle.Get_Config_File_Lengthy_Operation(), getConfigFileCancelled, false, 50, 1000);
        if (getConfigFileCancelled.get()) {
            log.log(Level.FINE, "Options Dialog - Getting config file for path ''{0}'', cancelled by user.", path);
        }
        return this.configFile;
    }

    private Point getUserLocation(OptionsPanel optionsPanel) {
        GraphicsDevice[] screenDevices;
        for (GraphicsDevice device : screenDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            Point userLocation = this.getUserLocation(device.getDefaultConfiguration(), optionsPanel);
            if (userLocation == null) continue;
            return userLocation;
        }
        return null;
    }

    private Point getUserLocation(GraphicsConfiguration gconf, OptionsPanel optionsPanel) {
        Rectangle screenBounds = Utilities.getUsableScreenBounds(gconf);
        int x = NbPreferences.forModule(OptionsDisplayerImpl.class).getInt("OptionsX", Integer.MAX_VALUE);
        int y = NbPreferences.forModule(OptionsDisplayerImpl.class).getInt("OptionsY", Integer.MAX_VALUE);
        Dimension userSize = optionsPanel.getUserSize();
        if ((double)x > (double)screenBounds.x + screenBounds.getWidth() || (double)y > (double)screenBounds.y + screenBounds.getHeight() || (double)(x + userSize.width) > (double)screenBounds.x + screenBounds.getWidth() || (double)(y + userSize.height) > (double)screenBounds.y + screenBounds.getHeight() || x < screenBounds.x && screenBounds.x >= 0 || x > screenBounds.x && screenBounds.x < 0 || y < screenBounds.y && screenBounds.y >= 0 || y > screenBounds.y && screenBounds.y < 0) {
            return null;
        }
        return new Point(x, y);
    }

    private static String loc(String key) {
        return NbBundle.getMessage(OptionsDisplayerImpl.class, key);
    }

    private static Component loc(Component c, String key) {
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)c, OptionsDisplayerImpl.loc(key));
        } else {
            Mnemonics.setLocalizedText((JLabel)c, OptionsDisplayerImpl.loc(key));
        }
        return c;
    }

    static {
        descriptorRef = new WeakReference<Object>(null);
        title = OptionsDisplayerImpl.loc("CTL_Options_Dialog_Title");
        log = Logger.getLogger(OptionsDisplayerImpl.class.getName());
        lookupListener = new LookupListenerImpl();
        RP = new RequestProcessor(OptionsDisplayerImpl.class.getName(), 1, true);
    }

    private class DefaultFSListener
    implements FileChangeListener {
        private DefaultFSListener() {
        }

        @Override
        public void fileRenamed(FileRenameEvent fe) {
            OptionsDisplayerImpl.this.updateButtons();
        }

        @Override
        public void fileChanged(FileEvent fe) {
            OptionsDisplayerImpl.this.updateButtons();
        }

        @Override
        public void fileFolderCreated(FileEvent fe) {
            OptionsDisplayerImpl.this.updateButtons();
        }

        @Override
        public void fileDataCreated(FileEvent fe) {
            OptionsDisplayerImpl.this.updateButtons();
        }

        @Override
        public void fileDeleted(FileEvent fe) {
            OptionsDisplayerImpl.this.updateButtons();
        }

        @Override
        public void fileAttributeChanged(FileAttributeEvent fe) {
            OptionsDisplayerImpl.this.updateButtons();
        }
    }

    private class OptionsPanelListener
    implements PropertyChangeListener,
    ActionListener {
        private DialogDescriptor descriptor;
        private OptionsPanel optionsPanel;
        private JButton bOK;
        private JButton bAPPLY;
        private HelpCtx helpCtx = HelpCtx.DEFAULT_HELP;

        OptionsPanelListener(DialogDescriptor descriptor, OptionsPanel optionsPanel, JButton bOK, JButton bAPPLY) {
            this.descriptor = descriptor;
            this.optionsPanel = optionsPanel;
            this.bOK = bOK;
            this.bAPPLY = bAPPLY;
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (ev.getPropertyName().equals("buranhelpCtx")) {
                AtomicBoolean helpCtxLoadingCancelled = new AtomicBoolean(false);
                ProgressUtils.runOffEventDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        OptionsPanelListener.this.helpCtx = OptionsPanelListener.this.optionsPanel.getHelpCtx();
                    }
                }, Bundle.Loading_HelpCtx_Lengthy_Operation(), helpCtxLoadingCancelled, false, 50, 5000);
                if (helpCtxLoadingCancelled.get()) {
                    log.fine("Options Dialog - HelpCtx loading cancelled by user.");
                }
                this.descriptor.setHelpCtx(this.helpCtx);
            } else if (ev.getPropertyName().equals("buranvalid")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OptionsPanelListener.this.bOK.setEnabled(OptionsPanelListener.this.optionsPanel.dataValid());
                        OptionsPanelListener.this.bAPPLY.setEnabled(OptionsPanelListener.this.optionsPanel.isChanged() && OptionsPanelListener.this.optionsPanel.dataValid());
                    }
                });
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.bOK) {
                log.fine("Options Dialog - Ok pressed.");
                this.saveOptionsOffEDT(true);
                if (OptionsDisplayerImpl.this.isOpen()) {
                    dialog.dispose();
                    dialog = null;
                }
            } else if (e.getSource() == this.bAPPLY) {
                log.fine("Options Dialog - Apply pressed.");
                this.saveOptionsOffEDT(false);
                this.bAPPLY.setEnabled(false);
            } else if (e.getSource() == DialogDescriptor.CANCEL_OPTION || e.getSource() == DialogDescriptor.CLOSED_OPTION) {
                log.fine("Options Dialog - Cancel pressed.");
                this.optionsPanel.cancel();
                this.bOK.setEnabled(true);
                this.bAPPLY.setEnabled(false);
                if (OptionsDisplayerImpl.this.isOpen()) {
                    dialog.dispose();
                    dialog = null;
                }
            }
        }

        private void saveOptionsOffEDT(final boolean okPressed) {
            OptionsDisplayerImpl.this.savingInProgress = true;
            JPanel content = new JPanel();
            content.add(new JLabel(Bundle.Saving_Options_Lengthy_Operation()));
            ProgressUtils.runOffEventThreadWithCustomDialogContent(new Runnable(){

                @Override
                public void run() {
                    if (okPressed) {
                        OptionsPanelListener.this.optionsPanel.save();
                    } else {
                        OptionsPanelListener.this.optionsPanel.save(true);
                    }
                }
            }, Bundle.Saving_Options_Lengthy_Operation_Title(), content, 50, 5000);
            OptionsDisplayerImpl.this.savingInProgress = false;
        }
    }

    private class MyWindowListener
    implements WindowListener {
        private OptionsPanel optionsPanel;
        private Dialog originalDialog;

        MyWindowListener(OptionsPanel optionsPanel, Dialog tmpDialog) {
            this.optionsPanel = optionsPanel;
            this.originalDialog = tmpDialog;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (dialog == null) {
                return;
            }
            log.fine("Options Dialog - windowClosing ");
            this.optionsPanel.cancel();
            OptionsDisplayerImpl.this.bOK.setEnabled(true);
            OptionsDisplayerImpl.this.bAPPLY.setEnabled(false);
            if (this.originalDialog == dialog) {
                dialog = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowClosed(WindowEvent e) {
            this.optionsPanel.storeUserSize();
            NbPreferences.forModule(OptionsDisplayerImpl.class).putInt("OptionsX", this.originalDialog.getX());
            NbPreferences.forModule(OptionsDisplayerImpl.class).putInt("OptionsY", this.originalDialog.getY());
            try {
                FileUtil.getConfigRoot().getFileSystem().removeFileChangeListener(OptionsDisplayerImpl.this.fcl);
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace(ex);
            }
            if (this.optionsPanel.needsReinit()) {
                LookupListener lookupListener = OptionsDisplayerImpl.lookupListener;
                synchronized (lookupListener) {
                    descriptorRef = new WeakReference<Object>(null);
                }
            }
            if (this.originalDialog == dialog) {
                dialog = null;
            }
            log.fine("Options Dialog - windowClosed");
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }
    }

    private static class LookupListenerImpl
    implements LookupListener {
        private LookupListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resultChanged(LookupEvent ev) {
            LookupListener lookupListener = OptionsDisplayerImpl.lookupListener;
            synchronized (lookupListener) {
                descriptorRef = new WeakReference<Object>(null);
                if (dialog != null) {
                    Mutex.EVENT.readAccess(new Runnable(){

                        @Override
                        public void run() {
                            if (dialog != null) {
                                log.log(Level.FINE, "Options Dialog - closing dialog when categories change.");
                                dialog.setVisible(false);
                                dialog = null;
                            }
                        }
                    });
                }
            }
        }
    }

    class OpenOptionsListener
    implements ActionListener {
        OpenOptionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            log.fine("Options Dialog - Back to modern.");
                            OptionsDisplayer.getDefault().open();
                        }
                    });
                }
            });
        }
    }
}

