/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.util.GenericUtils;

public class TtyFilterOutputStream
extends FilterOutputStream {
    public static final Set<PtyMode> OUTPUT_OPTIONS = Collections.unmodifiableSet(EnumSet.of(PtyMode.INLCR, PtyMode.ICRNL, PtyMode.IGNCR));
    private final Set<PtyMode> ttyOptions;

    public TtyFilterOutputStream(OutputStream out, Map<PtyMode, ?> modes) {
        this(out, PtyMode.resolveEnabledOptions(modes, OUTPUT_OPTIONS));
    }

    public TtyFilterOutputStream(OutputStream out, Collection<PtyMode> ttyOptions) {
        super(out);
        this.ttyOptions = GenericUtils.of(ttyOptions);
    }

    @Override
    public void write(int c) throws IOException {
        if (c == 13) {
            this.handleCR();
        } else if (c == 10) {
            this.handleLF();
        } else {
            this.writeRawOutput(c);
        }
    }

    protected void handleCR() throws IOException {
        if (this.ttyOptions.contains((Object)PtyMode.ICRNL)) {
            this.writeRawOutput(10);
        } else {
            if (this.ttyOptions.contains((Object)PtyMode.IGNCR)) {
                return;
            }
            this.writeRawOutput(13);
        }
    }

    protected void handleLF() throws IOException {
        if (this.ttyOptions.contains((Object)PtyMode.INLCR)) {
            this.writeRawOutput(13);
        } else {
            this.writeRawOutput(10);
        }
    }

    protected void writeRawOutput(int c) throws IOException {
        this.out.write(c);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 1) {
            this.write(b[off] & 0xFF);
            return;
        }
        int lastPos = 0;
        int maxPos = off + len;
        for (int curPos = off; curPos < maxPos; ++curPos) {
            int c = b[curPos] & 0xFF;
            if (c != 13 && c != 10) continue;
            if (lastPos < curPos) {
                this.writeRawOutput(b, lastPos, curPos - lastPos);
            }
            lastPos = curPos + 1;
            this.write(c);
        }
        if (lastPos < maxPos) {
            this.writeRawOutput(b, lastPos, maxPos - lastPos);
        }
    }

    protected void writeRawOutput(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }
}

